/*
 * Decompiled with CFR 0.152.
 */
package d112validator.v1;

import d112validator.Parameters;
import d112validator.v1.Angajator;
import d112validator.v1.AngajatorA;
import d112validator.v1.AngajatorC5;
import d112validator.v1.AngajatorF2;
import d112validator.v1.Asigurat;
import d112validator.v1.AsiguratA;
import d112validator.v1.AsiguratB1;
import d112validator.v1.AsiguratB11;
import d112validator.v1.AsiguratB2;
import d112validator.v1.AsiguratC;
import d112validator.v1.AsiguratD;
import d112validator.v1.CoAsigurati;
import d112validator.v1.Const;
import d112validator.v1.DUKTag;
import d112validator.v1.DbAccessImpl;
import dec.DECValidation;
import dec.Info;
import dec.LogTrace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidatorImpl
extends DefaultHandler
implements DECValidation {
    public static final String DEC_NAMESPACE = "mfp:anaf:dgti:declaratie_unica:declaratie:v1";
    long _integerValue;
    double _realValue;
    Date _dateValue;
    String _stringValue;
    boolean _attributeExists;
    static SimpleDateFormat _dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    static String _nl = System.getProperty("line.separator");
    Pattern _dblPattern = Pattern.compile("\\.");
    Pattern _emailPattern = Pattern.compile("[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
    long _option;
    private String _xmlFile;
    private String _errFile;
    private Attributes _attrib;
    private OutputStreamWriter _errorFile;
    private String _idAsig;
    private int _errorStatus;
    private String[] _tagNameStack = new String[3];
    private int[] _countStack = new int[3];
    private int _indStack;
    private int _tagCount;
    private int _tagDepth;
    private boolean[] _tagStack = new boolean[10];
    private int _tagStackInd;
    private String _lastTag;
    private int _status;
    private static final int[] _monthLen = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int ID_DECLARATIEUNICA = 0;
    static final int ID_ANGAJATOR = 1;
    static final int ID_ANGAJATORA = 2;
    static final int ID_ANGAJATORB = 3;
    static final int ID_ANGAJATORC1 = 4;
    static final int ID_ANGAJATORC2 = 5;
    static final int ID_ANGAJATORC3 = 6;
    static final int ID_ANGAJATORC4 = 7;
    static final int ID_ANGAJATORC5 = 8;
    static final int ID_ANGAJATORC6 = 9;
    static final int ID_ANGAJATORC7 = 10;
    static final int ID_ANGAJATORD = 11;
    static final int ID_ANGAJATORE1 = 12;
    static final int ID_ANGAJATORE2 = 13;
    static final int ID_ANGAJATORE3 = 14;
    static final int ID_ANGAJATORE4 = 15;
    static final int ID_ANGAJATORF1 = 16;
    static final int ID_ANGAJATORF2 = 17;
    static final int ID_ASIGURAT = 18;
    static final int ID_COASIGURATI = 19;
    static final int ID_ASIGURATA = 20;
    static final int ID_ASIGURATB1 = 21;
    static final int ID_ASIGURATB11 = 22;
    static final int ID_ASIGURATB2 = 23;
    static final int ID_ASIGURATB3 = 24;
    static final int ID_ASIGURATB4 = 25;
    static final int ID_ASIGURATC = 26;
    static final int ID_ASIGURATD = 27;
    public static final int MAX_OCC_ANGAJATORA = 41;
    public static final int MAX_OCC_ANGAJATORC5 = 10;
    public static final int MAX_OCC_ANGAJATORF2 = 1000;
    public static final int MAX_OCC_COASIGURATI = 3;
    public static final int MAX_OCC_ASIGURATB1 = 5;
    public static final int MAX_OCC_ASIGURATB11 = 50;
    public static final int MAX_OCC_ASIGURATD = 10;
    private static DUKTag[] _tags = new DUKTag[]{new DUKTag("declaratieUnica", 0, 0, true), new DUKTag("angajator", 1, 1, true), new DUKTag("angajatorA", 2, 2), new DUKTag("angajatorB", 3, 2), new DUKTag("angajatorC1", 4, 2), new DUKTag("angajatorC2", 5, 2), new DUKTag("angajatorC3", 6, 2), new DUKTag("angajatorC4", 7, 2), new DUKTag("angajatorC5", 8, 2), new DUKTag("angajatorC6", 9, 2), new DUKTag("angajatorC7", 10, 2), new DUKTag("angajatorD", 11, 2), new DUKTag("angajatorE1", 12, 2), new DUKTag("angajatorE2", 13, 2), new DUKTag("angajatorE3", 14, 2), new DUKTag("angajatorE4", 15, 2), new DUKTag("angajatorF1", 16, 2), new DUKTag("angajatorF2", 17, 2), new DUKTag("asigurat", 18, 1, true), new DUKTag("coAsigurati", 19, 2), new DUKTag("asiguratA", 20, 2), new DUKTag("asiguratB1", 21, 2, true), new DUKTag("asiguratB11", 22, 3), new DUKTag("asiguratB2", 23, 2), new DUKTag("asiguratB3", 24, 2), new DUKTag("asiguratB4", 25, 2), new DUKTag("asiguratC", 26, 2), new DUKTag("asiguratD", 27, 2)};
    private HashSet<String> _attribFullList;
    private boolean _emptyAttribListFlag;
    private int _effectiveAttribCount;
    private DbAccessImpl _dbObj = null;
    private boolean _writeDB;
    private Object _params = null;
    public Info _info = null;
    private Angajator _angajator = null;
    private AngajatorA[] _angajatorA = new AngajatorA[41];
    private int _cntAngajatorA;
    private AngajatorC5[] _angajatorC5 = new AngajatorC5[10];
    private int _cntAngajatorC5;
    private AngajatorF2[] _angajatorF2 = new AngajatorF2[1000];
    private int _cntAngajatorF2;
    private Asigurat _asigurat;
    long _cntAsigurat;
    private CoAsigurati[] _coAsigurati = new CoAsigurati[3];
    private int _cntCoAsigurati;
    private AsiguratA _asiguratA;
    private AsiguratB2 _asiguratB2;
    private AsiguratB1[] _asiguratB1 = new AsiguratB1[5];
    private int _cntAsiguratB1;
    private AsiguratB11[] _asiguratB11 = new AsiguratB11[50];
    private int _cntAsiguratB11;
    private int _indAsiguratB11perB1;
    private AsiguratC _asiguratC;
    private AsiguratD[] _asiguratD = new AsiguratD[10];
    private int _cntAsiguratD;
    boolean _existsAngajatorC1;
    boolean _existsAngajatorC2;
    boolean _existsAngajatorC3;
    boolean _existsAngajatorC4;
    boolean _existsAngajatorC7;
    boolean _existsAngajatorD;
    boolean _existsAngajatorE1;
    boolean _existsAngajatorE2;
    boolean _existsAngajatorE3;
    boolean _existsAngajatorE4;
    boolean _existsAngajatorF1;
    int _asigType;
    boolean _existsAsiguratB2;
    boolean _existsAsiguratB3;
    boolean _existsAsiguratC;
    int _extractValuesFlag = 0;

    public int parseDocument(String string, String string2, Info info, Object object) {
        int n = this.parseDocument(string, string2, info, object, 0);
        return n;
    }

    public int parseDocument(String string, String string2, Info info, Object object, int n) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        String[] stringArray5;
        String[] stringArray6;
        int n2;
        int n3 = 2;
        String string3 = null;
        this._extractValuesFlag = n;
        this._params = object;
        info._schemaNamespace = null;
        this._info = info;
        this._xmlFile = string;
        this._errFile = string2 == null || string2.equals("") ? this._xmlFile + ".err.txt" : string2;
        this._tagStackInd = -1;
        this._indStack = -1;
        this._errorFile = null;
        this._errorStatus = 0;
        this._tagCount = 0;
        this._tagDepth = -1;
        this._status = -1;
        this._idAsig = "";
        this._cntAsigurat = 0L;
        if (this._angajator == null) {
            this._angajator = new Angajator(this, null);
            for (n2 = 0; n2 < this._angajatorA.length; ++n2) {
                this._angajatorA[n2] = new AngajatorA(this, this._angajator);
            }
            for (n2 = 0; n2 < this._angajatorC5.length; ++n2) {
                this._angajatorC5[n2] = new AngajatorC5(this, this._angajator);
            }
            for (n2 = 0; n2 < this._angajatorF2.length; ++n2) {
                this._angajatorF2[n2] = new AngajatorF2(this, this._angajator);
            }
            this._asigurat = new Asigurat(this, this._angajator);
            for (n2 = 0; n2 < this._coAsigurati.length; ++n2) {
                this._coAsigurati[n2] = new CoAsigurati(this, this._asigurat);
            }
            this._asiguratA = new AsiguratA(this, this._asigurat);
            this._asiguratB2 = new AsiguratB2(this, this._asigurat);
            for (n2 = 0; n2 < this._asiguratB1.length; ++n2) {
                this._asiguratB1[n2] = new AsiguratB1(this, this._asigurat);
            }
            for (n2 = 0; n2 < this._asiguratB11.length; ++n2) {
                this._asiguratB11[n2] = new AsiguratB11(this, null);
            }
            this._asiguratC = new AsiguratC(this, this._asigurat);
            for (n2 = 0; n2 < this._asiguratD.length; ++n2) {
                this._asiguratD[n2] = new AsiguratD(this, this._asigurat);
            }
        } else {
            this._angajator.setParams();
            for (n2 = 0; n2 < this._angajatorA.length; ++n2) {
                this._angajatorA[n2].setParams();
            }
            for (n2 = 0; n2 < this._angajatorC5.length; ++n2) {
                this._angajatorC5[n2].setParams();
            }
            for (n2 = 0; n2 < this._angajatorF2.length; ++n2) {
                this._angajatorF2[n2].setParams();
            }
            this._asigurat.setParams();
            for (n2 = 0; n2 < this._coAsigurati.length; ++n2) {
                this._coAsigurati[n2].setParams();
            }
            this._asiguratA.setParams();
            this._asiguratB2.setParams();
            for (n2 = 0; n2 < this._asiguratB1.length; ++n2) {
                this._asiguratB1[n2].setParams();
            }
            for (n2 = 0; n2 < this._asiguratB11.length; ++n2) {
                this._asiguratB11[n2].setParams();
            }
            this._asiguratC.setParams();
            for (n2 = 0; n2 < this._asiguratD.length; ++n2) {
                this._asiguratD[n2].setParams();
            }
        }
        this._cntAngajatorA = 0;
        this._cntAngajatorC5 = 0;
        this._cntAngajatorF2 = 0;
        this._cntCoAsigurati = 0;
        this._cntAsiguratB1 = 0;
        this._cntAsiguratB11 = 0;
        this._indAsiguratB11perB1 = 0;
        this._cntAsiguratD = 0;
        this._existsAngajatorC1 = false;
        this._existsAngajatorC2 = false;
        this._existsAngajatorC3 = false;
        this._existsAngajatorC4 = false;
        this._existsAngajatorC7 = false;
        this._existsAngajatorD = false;
        this._existsAngajatorE1 = false;
        this._existsAngajatorE2 = false;
        this._existsAngajatorE3 = false;
        this._existsAngajatorE4 = false;
        this._existsAngajatorF1 = false;
        this._asigType = -1;
        this._existsAsiguratB2 = false;
        this._existsAsiguratB3 = false;
        this._existsAsiguratC = false;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            stringArray6 = sAXParserFactory.newSAXParser();
            stringArray6.parse(this._xmlFile, (DefaultHandler)this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            n3 = 3;
            string3 = fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            string3 = iOException.getMessage();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string3 = parserConfigurationException.getMessage();
        }
        catch (SAXParseException sAXParseException) {
            string3 = sAXParseException.getMessage();
        }
        catch (SAXException sAXException) {
            string3 = sAXException.getMessage();
        }
        catch (Throwable throwable) {
            string3 = throwable.toString();
        }
        if (string3 != null) {
            this.addError(3, "", "", this.fillParams("Eroare fatala de parsare: '@0@'", string3), n3);
        }
        try {
            if (this._errorFile != null) {
                this._errorFile.close();
            }
        }
        catch (Throwable throwable) {
            LogTrace.log((String)("Eroare fatala: " + throwable.getMessage()), (int)2);
            this._errorStatus |= 0xF;
        }
        int n4 = 0;
        if (this.getErrors() != 0) {
            n4 = -1;
            if (this.hasFatalErrors() != 0) {
                n4 = -2;
                if (this.hasTechnicalErrors() != 0) {
                    n4 = -3;
                }
            }
        }
        if (this._dbObj != null && n4 != -3) {
            try {
                stringArray6 = new File(this._xmlFile);
                stringArray6.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this._dbObj != null && this._errorStatus != 0) {
            stringArray6 = null;
            stringArray5 = null;
            stringArray4 = null;
            stringArray3 = null;
            stringArray2 = null;
            stringArray = new StringBuffer(500);
            boolean bl = false;
            boolean bl2 = false;
            try {
                stringArray6 = new BufferedReader(new FileReader(string2));
                while (true) {
                    if ((stringArray5 = stringArray6.readLine()) == null || !stringArray5.startsWith(" ")) {
                        if (bl && (stringArray3 = this._dbObj.insertError((String)stringArray4, stringArray.toString())) != null) {
                            LogTrace.log((String)("Eroare fatala: " + (String)stringArray3), (int)2);
                            this._errorStatus |= 0xF;
                            n4 = -3;
                            break;
                        }
                        if (stringArray5 == null) break;
                        bl = true;
                        bl2 = false;
                        stringArray.setLength(0);
                        stringArray2 = stringArray5.split("\\|", 2);
                        if (stringArray2.length < 2) {
                            stringArray4 = "E???";
                        } else {
                            stringArray4 = stringArray2[0];
                            stringArray5 = stringArray2[1];
                        }
                    }
                    if (bl2) {
                        stringArray.append(_nl);
                    }
                    bl2 = true;
                    stringArray.append((String)stringArray5);
                }
            }
            catch (Throwable throwable) {
                LogTrace.log((String)("Eroare fatala: " + throwable.getMessage()), (int)2);
                this._errorStatus |= 0xF;
                n4 = -3;
            }
            try {
                stringArray6.close();
                if (n4 != -3) {
                    File file = new File(this._errFile);
                    file.delete();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this._dbObj != null) {
            this._dbObj.endDeclaratie(n4);
        }
        if (n4 < 0) {
            return n4;
        }
        info._luna = this.adjustString(this._angajator._luna_r);
        info._an = this.adjustString(this._angajator._an_r);
        info._rec = this.adjustString(this._angajator._tip_rec);
        info._tipPerioada = "L";
        info._perioada = info._luna;
        if (info._rec.equals("")) {
            info._rec = "0";
        }
        info._numeDeclar = this.adjustString(this._angajator._nume_declar);
        info._prenumeDeclar = this.adjustString(this._angajator._prenume_declar);
        info._functieDeclar = this.adjustString(this._angajator._functie_declar);
        info._cif = this.adjustString(this._angajator._cif);
        info._denumire = this.adjustString(this._angajator._den);
        info._adresa = this.adjustString(this._angajator._adrFisc);
        info._telefon = this.adjustString(this._angajator._telFisc);
        info._fax = this.adjustString(this._angajator._faxFisc);
        info._mail = this.adjustString(this._angajator._mailFisc);
        info._sumaControl = this.adjustString(this._angajator._totalPlata_A);
        info.setValue("_rgCom", (Object)this.adjustString(this._angajator._rgCom));
        stringArray6 = new String[this._cntAngajatorA];
        stringArray5 = new String[this._cntAngajatorA];
        stringArray4 = new String[this._cntAngajatorA];
        stringArray3 = new String[this._cntAngajatorA];
        stringArray2 = new String[this._cntAngajatorA];
        stringArray = new String[this._cntAngajatorA];
        String[] stringArray7 = new String[this._cntAngajatorA];
        info.setValue("_cnt", (Object)Long.toString(this._cntAngajatorA));
        info.setValue("_codOblig", (Object)stringArray6);
        info.setValue("_numeOblig", (Object)stringArray);
        info.setValue("_idOblig", (Object)stringArray7);
        info.setValue("_codBugetar", (Object)stringArray5);
        info.setValue("_datorat", (Object)stringArray4);
        info.setValue("_deductibil", (Object)stringArray3);
        info.setValue("_plata", (Object)stringArray2);
        Parameters.DUKOblig dUKOblig = new Parameters.DUKOblig("", "", -1, "");
        for (int i = 0; i < this._cntAngajatorA; ++i) {
            stringArray5[i] = this.adjustString(this._angajatorA[i]._A_codBugetar);
            dUKOblig._oblig = this._angajatorA[i]._A_codOblig;
            int n5 = Arrays.binarySearch(((Parameters)this._params)._A_codOblig_Bugetar, dUKOblig);
            stringArray[i] = this.adjustString(((Parameters)this._params)._A_codOblig_Bugetar[n5]._name);
            stringArray7[i] = Integer.toString(((Parameters)this._params)._A_codOblig_Bugetar[n5]._index + 1);
            stringArray6[i] = this.adjustString(this._angajatorA[i]._A_codOblig);
            stringArray4[i] = this.adjustString(this._angajatorA[i]._A_datorat);
            stringArray3[i] = this.adjustString(this._angajatorA[i]._A_deductibil);
            stringArray2[i] = this.adjustString(this._angajatorA[i]._A_plata);
        }
        if (this.getWarnings() != 0) {
            return 1;
        }
        return 0;
    }

    int addError(int n, String string, String string2, String string3) {
        return this.addError(n, string, string2, string3, 1);
    }

    int addError(int n, String string, String string2, String string3, int n2) {
        String string4;
        StringBuffer stringBuffer = new StringBuffer(500);
        String string5 = string4 = n2 == 0 ? "atentionare" : "eroare";
        if (this._errorFile == null) {
            try {
                this._errorFile = new OutputStreamWriter((OutputStream)new FileOutputStream(this._errFile), "UTF-8");
            }
            catch (IOException iOException) {
                LogTrace.log((String)("Eroare fatala: " + iOException.getMessage()), (int)2);
                this._errorStatus |= 0xF;
                return this._errorStatus;
            }
        }
        if (this._dbObj != null) {
            switch (n2) {
                case 0: {
                    stringBuffer.append("A");
                    break;
                }
                case 3: {
                    stringBuffer.append("T");
                    break;
                }
                default: {
                    stringBuffer.append("E");
                }
            }
            switch (n) {
                case 0: {
                    stringBuffer.append("C");
                    break;
                }
                case 1: {
                    stringBuffer.append("R");
                    break;
                }
                case 2: {
                    stringBuffer.append("S");
                    break;
                }
                case 3: {
                    stringBuffer.append("G");
                }
            }
            stringBuffer.append(string);
            stringBuffer.append("|");
        }
        if (n2 == 0) {
            stringBuffer.append("A:");
        } else if (n2 == 1) {
            stringBuffer.append("E:");
        } else if (n2 == 2) {
            stringBuffer.append("F:");
        } else {
            stringBuffer.append("T:");
        }
        if (n2 > 0 && this._writeDB) {
            this._dbObj.rollBack();
            this._writeDB = false;
        }
        for (int i = 0; i <= this._indStack; ++i) {
            stringBuffer.append(" " + (i == 0 ? "" : "sectiune ") + this._tagNameStack[i] + " (" + Integer.toString(this._countStack[i]) + ")");
            if (i != 0 || this._idAsig == null || this._idAsig.equals("")) continue;
            stringBuffer.append(" [" + this._idAsig + "]");
        }
        if (this._indStack < 0) {
            stringBuffer.append(" validari globale");
        }
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append(_nl + " " + string2);
        }
        stringBuffer.append(_nl);
        switch (n) {
            case 0: {
                stringBuffer.append(" " + string4 + " atribut: " + string + ": ");
                break;
            }
            case 1: {
                stringBuffer.append(" " + string4 + " regula: " + string + (!string.equals("") ? ": " : ""));
                break;
            }
            case 2: {
                stringBuffer.append(" " + string4 + " structura: ");
                break;
            }
            case 3: {
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(string3 + _nl);
        try {
            this._errorFile.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            LogTrace.log((String)("Eroare fatala: " + iOException.getMessage()), (int)2);
            this._errorStatus |= 0xF;
            return this._errorStatus;
        }
        this._errorStatus = n2 == 0 ? (this._errorStatus |= 0x10) : (n2 == 1 ? (this._errorStatus |= 3) : (n2 == 2 ? (this._errorStatus |= 7) : (this._errorStatus |= 0xF)));
        return this._errorStatus;
    }

    String nextAttribute(String string, int n, int n2, int n3) {
        this._stringValue = null;
        this._integerValue = 0L;
        this._realValue = 0.0;
        this._dateValue = null;
        this._attributeExists = false;
        if ((this._errorStatus & 1) != 0) {
            this._errorStatus |= 2;
        }
        this._errorStatus &= 0xFFFFFFFE;
        if (this._emptyAttribListFlag) {
            this._attribFullList.add(string);
        }
        if (this._attrib != null) {
            this._stringValue = this._attrib.getValue(string);
        }
        if (this._stringValue != null) {
            if ((n3 & 8) == 0) {
                this._stringValue = this._stringValue.trim();
            }
            this._attributeExists = true;
            ++this._effectiveAttribCount;
        }
        if (this._stringValue != null && !this._stringValue.equals("")) {
            switch (n2) {
                case 1: {
                    try {
                        this._integerValue = Long.parseLong(this._stringValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.addError(0, string, "", this.fillParams("numar intreg eronat: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 2: {
                    try {
                        this._realValue = Double.parseDouble(this._stringValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.addError(0, string, "", this.fillParams("numar real eronat: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 3: {
                    try {
                        this._dateValue = _dateFormat.parse(this._stringValue);
                        if (this._dateValue.getYear() < 0) {
                            throw new ParseException("", 0);
                        }
                    }
                    catch (ParseException parseException) {
                        this.addError(0, string, "", this.fillParams("data calendaristica eronata: '@0@'", this._stringValue));
                    }
                    break;
                }
                case 4: {
                    if (this._stringValue.length() <= n) break;
                    this.addError(0, string, "", this.fillParams("sir mai lung de @0@ caractere ('@1@')", Integer.toString(n), this._stringValue));
                    break;
                }
                default: {
                    this.addError(0, string, "", "eroare interna sau de programare");
                }
            }
            if ((n3 & 3) == 2) {
                this.addError(0, string, "", this.fillParams("atributul cu valoarea: '@0@' nu trebuie sa existe aici", this._stringValue));
            }
        } else if (this._stringValue != null && this._stringValue.equals("")) {
            if ((n3 & 4) == 0) {
                this.addError(0, string, "", "atribut prezent dar vid nepermis");
            }
        } else if ((n3 & 3) == 1) {
            this.addError(0, string, "", "atributul trebuie sa existe");
        }
        return this._stringValue;
    }

    String nextAttributeInList(Object[] objectArray, String string, int n, int n2, int n3) {
        int n4 = 0;
        String string2 = this.nextAttribute(string, n, n2, n3);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        switch (n2) {
            case 1: {
                if (Arrays.binarySearch(objectArray, (Object)this._integerValue) < 0) {
                    n4 = objectArray.length;
                    break;
                }
                n4 = 0;
                break;
            }
            case 2: {
                for (n4 = 0; n4 < objectArray.length && this._realValue != (Double)objectArray[n4]; ++n4) {
                }
                break;
            }
            case 3: {
                for (n4 = 0; n4 < objectArray.length && !this._dateValue.equals((Date)objectArray[n4]); ++n4) {
                }
                break;
            }
            case 4: {
                n4 = Arrays.binarySearch(objectArray, this._stringValue) < 0 ? objectArray.length : 0;
            }
        }
        if (n4 >= objectArray.length) {
            this.addError(0, string, "", this.fillParams("valoarea '@0@' nu se afla in lista", this._stringValue));
        }
        return string2;
    }

    String nextAttributeInInterval(Object object, Object object2, String string, int n, int n2, int n3) {
        boolean bl = false;
        String string2 = this.nextAttribute(string, n, n2, n3);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        switch (n2) {
            case 1: {
                if (object2 != null && this._integerValue > (Long)object2 || object != null && this._integerValue < (Long)object) break;
                bl = true;
                break;
            }
            case 2: {
                if (object2 != null && !(this._realValue <= (Double)object2) || object != null && !(this._realValue >= (Double)object)) break;
                bl = true;
                break;
            }
            case 3: {
                if (object2 != null && !this._dateValue.before((Date)object2) && !this._dateValue.equals((Date)object2) || object != null && !this._dateValue.after((Date)object) && !this._dateValue.equals((Date)object)) break;
                bl = true;
                break;
            }
            case 4: {
                if (object2 != null && this._stringValue.compareTo((String)object2) > 0 || object != null && this._stringValue.compareTo((String)object) < 0) break;
                bl = true;
            }
        }
        if (!bl) {
            this.addError(0, string, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue));
        }
        return string2;
    }

    String nextAttributeDblPattern(Object object, Object object2, int n, int n2, String string, int n3) {
        String string2 = this.nextAttribute(string, 0, 2, n3);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (object2 != null && this._realValue > (Double)object2 || object != null && this._realValue < (Double)object) {
            this.addError(0, string, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue));
            return string2;
        }
        String[] stringArray = this._dblPattern.split(string2, 0);
        boolean bl = false;
        if (stringArray.length > 0 && stringArray[0].length() > n) {
            bl = true;
        }
        if (stringArray.length > 1 && stringArray[1].length() > n2) {
            bl = true;
        }
        if (bl) {
            this.addError(0, string, "", this.fillParams("numarul zecimal ('@0@') nu respecta modelul: @1@.@2@", this._stringValue, Integer.toString(n), Integer.toString(n2)));
        }
        return string2;
    }

    char[] getBinaryValues(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return null;
            }
            cArray[i] = (char)(c - 48);
        }
        return cArray;
    }

    int checkCNP(String string) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.length() != 13) {
            return -1;
        }
        char[] cArray = this.getBinaryValues(string);
        if (cArray == null) {
            return -1;
        }
        char c = cArray[0];
        if (c != '\u0001' && c != '\u0002' && c != '\u0005' && c != '\u0006' && c != '\u0007' && c != '\b') {
            return -1;
        }
        int n = cArray[1] * 10 + cArray[2];
        int n2 = cArray[3] * 10 + cArray[4];
        int n3 = cArray[5] * 10 + cArray[6];
        if (n2 == 0 || n2 > 12 || n3 == 0 || n3 > _monthLen[n2 - 1] || n2 == 2 && n3 == 29 && (n % 4 != 0 || n == 0)) {
            return -1;
        }
        n3 = (cArray[0] * 2 + cArray[1] * 7 + cArray[2] * 9 + cArray[3] * '\u0001' + cArray[4] * 4 + cArray[5] * 6 + cArray[6] * 3 + cArray[7] * 5 + cArray[8] * 8 + cArray[9] * 2 + cArray[10] * 7 + cArray[11] * 9) % 11;
        if (n3 == 10) {
            n3 = 1;
        }
        if (n3 != cArray[12]) {
            return -1;
        }
        return 0;
    }

    int checkNIF(String string) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.length() != 13) {
            return -1;
        }
        char[] cArray = this.getBinaryValues(string);
        if (cArray == null) {
            return -1;
        }
        char c = cArray[0];
        if (c == '\t') {
            int n = (cArray[0] * 2 + cArray[1] * 7 + cArray[2] * 9 + cArray[3] * '\u0001' + cArray[4] * 4 + cArray[5] * 6 + cArray[6] * 3 + cArray[7] * 5 + cArray[8] * 8 + cArray[9] * 2 + cArray[10] * 7 + cArray[11] * 9) % 11;
            if (n == 10) {
                n = 1;
            }
            if (n != cArray[12]) {
                return -1;
            }
        } else {
            return this.checkCNP(string);
        }
        return 0;
    }

    int checkCUI(String string) {
        int n;
        char[] cArray = new char[10];
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        if (n2 > 10 || string.startsWith("0")) {
            return -1;
        }
        char[] cArray2 = this.getBinaryValues(string);
        if (cArray2 == null) {
            return -1;
        }
        for (n = 0; n < 10 - n2; ++n) {
            cArray[n] = '\u0000';
        }
        for (n = 0; n < n2; ++n) {
            cArray[n + 10 - n2] = cArray2[n];
        }
        n2 = (cArray[0] * 7 + cArray[1] * 5 + cArray[2] * 3 + cArray[3] * 2 + cArray[4] * '\u0001' + cArray[5] * 7 + cArray[6] * 5 + cArray[7] * 3 + cArray[8] * 2) * 10 % 11;
        if (n2 == 10) {
            n2 = 0;
        }
        if (n2 != cArray[9]) {
            return -1;
        }
        return 0;
    }

    String nextAttributeStringAsLong(String string, int n, int n2) {
        String string2 = this.nextAttribute(string, n, 4, n2);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.getBinaryValues(string2) == null) {
            this.addError(0, string, "", this.fillParams("valoare nenumerica ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeEmail(String string, int n, int n2) {
        String string2 = this.nextAttribute(string, n, 4, n2);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        Matcher matcher = this._emailPattern.matcher(string2);
        if (!matcher.matches()) {
            this.addError(0, string, "", this.fillParams("Email invalid ('@0@')", this._stringValue), 0);
        }
        return string2;
    }

    String nextAttributeAsCnp(String string, int n) {
        String string2 = this.nextAttribute(string, 13, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.checkCNP(string2) != 0) {
            this.addError(0, string, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeAsNif(String string, int n) {
        String string2 = this.nextAttribute(string, 13, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.checkNIF(string2) != 0) {
            this.addError(0, string, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeAsCui(String string, int n) {
        String string2 = this.nextAttribute(string, 10, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (this.checkCUI(string2) != 0) {
            this.addError(0, string, "", this.fillParams("CUI invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    String nextAttributeAsCif(String string, int n) {
        String string2 = this.nextAttribute(string, 13, 4, n);
        if (this.hasCurrentAttributeErrors() != 0 || string2 == null || string2.equals("")) {
            return string2;
        }
        if (string2.length() <= 10) {
            if (this.checkCUI(string2) != 0) {
                this.addError(0, string, "", this.fillParams("CUI invalid ('@0@')", this._stringValue));
            }
        } else if (string2.length() == 13) {
            if (this.checkNIF(string2) != 0) {
                this.addError(0, string, "", this.fillParams("CNP invalid ('@0@')", this._stringValue));
            }
        } else {
            this.addError(0, string, "", this.fillParams("Cod identificare fiscala (CIF) invalid ('@0@')", this._stringValue));
        }
        return string2;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        DUKTag dUKTag = new DUKTag(string2, 0, 0);
        if (this._info._schemaNamespace == null) {
            this._info._schemaNamespace = string;
        }
        ++this._tagCount;
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        ++this._tagDepth;
        this._effectiveAttribCount = 0;
        this._attrib = attributes;
        int n = Arrays.binarySearch(_tags, dUKTag);
        if (n < 0) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", string2), 2);
            return;
        }
        int n2 = ValidatorImpl._tags[n]._tagDepth;
        ++this._tagStackInd;
        this._lastTag = string2;
        this._tagStack[this._tagStackInd] = ValidatorImpl._tags[n]._whiteSpaceFlag;
        n = ValidatorImpl._tags[n]._tagId;
        int n3 = -1;
        switch (n) {
            case 0: {
                if (this._status != -1) {
                    n3 = 0;
                    break;
                }
                this._angajator.initialization();
                this._angajator.checkTag(0);
                if (this._extractValuesFlag != 1) break;
                this._extractValuesFlag = 2;
                break;
            }
            case 1: {
                if (this._status != 0) {
                    n3 = 0;
                    break;
                }
                this._indStack = 0;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(1);
                break;
            }
            case 2: {
                if (this._status != 2 && this._status != 5) {
                    if (n2 != this._tagDepth) {
                        n3 = 1;
                        break;
                    }
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status == 2) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n4 = this._indStack;
                    this._countStack[n4] = this._countStack[n4] + 1;
                }
                if (this._cntAngajatorA >= this._angajatorA.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorA.length)), 2);
                    break;
                }
                this._angajatorA[this._cntAngajatorA].initialization();
                this._angajatorA[this._cntAngajatorA].checkTag(0);
                break;
            }
            case 3: {
                if (this._status != 5) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(2);
                break;
            }
            case 4: {
                this._existsAngajatorC1 = true;
                if (this._status != 7) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(3);
                break;
            }
            case 5: {
                this._existsAngajatorC2 = true;
                if (this._status != 7 && this._status != 9) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(4);
                break;
            }
            case 6: {
                this._existsAngajatorC3 = true;
                if (this._status != 7 && this._status != 9 && this._status != 11) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(5);
                break;
            }
            case 7: {
                this._existsAngajatorC4 = true;
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(6);
                break;
            }
            case 8: {
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13 && this._status != 15 && this._status != 17) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 17) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n5 = this._indStack;
                    this._countStack[n5] = this._countStack[n5] + 1;
                }
                if (this._cntAngajatorC5 >= this._angajatorC5.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorC5.length)), 2);
                    break;
                }
                this._angajatorC5[this._cntAngajatorC5].initialization();
                this._angajatorC5[this._cntAngajatorC5].checkTag(0);
                break;
            }
            case 9: {
                if (this._status != 7 && this._status != 9 && this._status != 11 && this._status != 13 && this._status != 15 && this._status != 17) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(7);
                break;
            }
            case 10: {
                this._existsAngajatorC7 = true;
                if (this._status != 19) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(8);
                break;
            }
            case 11: {
                this._existsAngajatorD = true;
                if (this._status != 19 && this._status != 21) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(9);
                break;
            }
            case 12: {
                this._existsAngajatorE1 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(10);
                break;
            }
            case 13: {
                this._existsAngajatorE2 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(11);
                break;
            }
            case 14: {
                this._existsAngajatorE3 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25 && this._status != 27) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(12);
                break;
            }
            case 15: {
                this._existsAngajatorE4 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 29) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(13);
                break;
            }
            case 16: {
                this._existsAngajatorF1 = true;
                if (this._status != 19 && this._status != 21 && this._status != 23 && this._status != 25 && this._status != 27 && this._status != 29 && this._status != 31) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._angajator.checkTag(14);
                break;
            }
            case 17: {
                if (this._status != 33 && this._status != 35) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 35) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n6 = this._indStack;
                    this._countStack[n6] = this._countStack[n6] + 1;
                }
                if (this._cntAngajatorF2 >= this._angajatorF2.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._angajatorF2.length)), 2);
                    break;
                }
                this._angajatorF2[this._cntAngajatorF2].initialization();
                this._angajatorF2[this._cntAngajatorF2].checkTag(0);
                break;
            }
            case 18: {
                if (this._status != 3 && this._status != 37) {
                    n3 = 2;
                } else {
                    this._indStack = 0;
                    this._tagNameStack[this._indStack] = string2;
                    if (this._status == 3) {
                        this._countStack[this._indStack] = 1;
                    } else {
                        int n7 = this._indStack;
                        this._countStack[n7] = this._countStack[n7] + 1;
                    }
                    this._asigurat.initialization();
                    this._asigurat.checkTag(0);
                }
                this._cntCoAsigurati = 0;
                this._cntAsiguratB1 = 0;
                this._cntAsiguratB11 = 0;
                this._indAsiguratB11perB1 = 0;
                this._cntAsiguratD = 0;
                this._asigType = -1;
                this._existsAsiguratB2 = false;
                this._existsAsiguratB3 = false;
                this._existsAsiguratC = false;
                break;
            }
            case 19: {
                if (this._status != 39 && this._status != 36) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status == 36) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n8 = this._indStack;
                    this._countStack[n8] = this._countStack[n8] + 1;
                }
                if (this._cntCoAsigurati >= this._coAsigurati.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._coAsigurati.length)), 2);
                    break;
                }
                this._coAsigurati[this._cntCoAsigurati].initialization();
                this._coAsigurati[this._cntCoAsigurati].checkTag(0);
                break;
            }
            case 20: {
                if (this._status != 39 && this._status != 36) {
                    n3 = 2;
                } else {
                    this._indStack = 1;
                    this._tagNameStack[this._indStack] = string2;
                    this._countStack[this._indStack] = 1;
                    this._asiguratA.initialization();
                    this._asiguratA.checkTag(0);
                }
                this._asigType = 0;
                break;
            }
            case 21: {
                if (this._status != 39 && this._status != 36 && this._status != 43) {
                    n3 = 2;
                } else {
                    this._indStack = 1;
                    this._tagNameStack[this._indStack] = string2;
                    if (this._status != 43) {
                        this._countStack[this._indStack] = 1;
                    } else {
                        int n9 = this._indStack;
                        this._countStack[n9] = this._countStack[n9] + 1;
                    }
                    if (this._cntAsiguratB1 >= this._asiguratB1.length) {
                        this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratB1.length)), 2);
                    } else {
                        this._asiguratB1[this._cntAsiguratB1].initialization();
                        this._asiguratB1[this._cntAsiguratB1].checkTag(0);
                    }
                }
                this._indAsiguratB11perB1 = 0;
                this._asigType = 1;
                break;
            }
            case 22: {
                if (this._status != 42 && this._status != 45) {
                    n3 = 2;
                    break;
                }
                this._indStack = 2;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 45) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n10 = this._indStack;
                    this._countStack[n10] = this._countStack[n10] + 1;
                }
                if (this._indAsiguratB11perB1 > 10 || this._cntAsiguratB11 >= this._asiguratB11.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratB11.length)), 2);
                    break;
                }
                this._asiguratB11[this._cntAsiguratB11].setParent(this._asiguratB1[this._cntAsiguratB1]);
                this._asiguratB11[this._cntAsiguratB11].initialization();
                this._asiguratB11[this._cntAsiguratB11].checkTag(0);
                break;
            }
            case 23: {
                this._existsAsiguratB2 = true;
                if (this._status != 43) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._asiguratB2.initialization();
                this._asiguratB2.checkTag(0);
                break;
            }
            case 24: {
                this._existsAsiguratB3 = true;
                if (this._status != 43 && this._status != 47) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                if (!this._existsAsiguratB2) {
                    this._asiguratB2.initialization();
                }
                this._asiguratB2.checkTag(1);
                break;
            }
            case 25: {
                if (this._status != 43 && this._status != 47 && this._status != 49) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                if (!this._existsAsiguratB2 && !this._existsAsiguratB3) {
                    this._asiguratB2.initialization();
                }
                this._asiguratB2.checkTag(2);
                break;
            }
            case 26: {
                if (this._asigType < 0) {
                    this._asigType = 2;
                }
                this._existsAsiguratC = true;
                if (this._status != 39 && this._status != 36 && this._status != 41 && this._status != 51) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                this._countStack[this._indStack] = 1;
                this._asiguratC.initialization();
                this._asiguratC.checkTag(0);
                break;
            }
            case 27: {
                if (this._status != 51 && this._status != 53 && this._status != 55) {
                    n3 = 2;
                    break;
                }
                this._indStack = 1;
                this._tagNameStack[this._indStack] = string2;
                if (this._status != 55) {
                    this._countStack[this._indStack] = 1;
                } else {
                    int n11 = this._indStack;
                    this._countStack[n11] = this._countStack[n11] + 1;
                }
                if (this._cntAsiguratD >= this._asiguratD.length) {
                    this.addError(2, null, "", this.fillParams("prea multe sectiuni repetitive (maximum @0@ permise)", Integer.toString(this._asiguratD.length)), 2);
                    break;
                }
                this._asiguratD[this._cntAsiguratD].initialization();
                this._asiguratD[this._cntAsiguratD].checkTag(0);
            }
        }
        if (!string.equals(DEC_NAMESPACE)) {
            this.addError(2, null, "", this.fillParams("namespace ('@0@') lipsa sau incorect la sectiunea @1@. Valoarea corecta este xmlns='@2@'", string, string2, DEC_NAMESPACE), 2);
            return;
        }
        if (n3 >= 0) {
            String string4 = "";
            switch (n3) {
                case 0: {
                    string4 = "sectiunea @0@' nu poate aparea de mai multe ori in acest context";
                    break;
                }
                case 1: {
                    string4 = "sectiunea '@0@' apare pe un nivel incorect";
                    break;
                }
                case 2: {
                    string4 = "sectiunea '@0@' este gresit pozitionata sau lipsesc sectiuni anterioare obligatorii";
                }
            }
            this.addError(2, null, "", this.fillParams(string4, string2), 2);
        }
        this._status = 2 * n;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        DUKTag dUKTag = new DUKTag(string2, 0, 0);
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        --this._tagDepth;
        --this._tagStackInd;
        int n = Arrays.binarySearch(_tags, dUKTag);
        if (n < 0) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", string2), 2);
            return;
        }
        int n2 = ValidatorImpl._tags[n]._tagDepth;
        n = ValidatorImpl._tags[n]._tagId;
        int n3 = -1;
        switch (n) {
            case 0: {
                this._indStack = -1;
                if (this._status != 37 && this._status != 3) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(0);
                if (!this._writeDB) break;
                this._dbObj.validariFinale();
                if (this._writeDB) break;
                break;
            }
            case 1: {
                this._indStack = 0;
                if (this._status != 35 && this._status != 33 && this._status != 31 && this._status != 29 && this._status != 27 && this._status != 25 && this._status != 23 && this._status != 21 && this._status != 19) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(1);
                if (!this._writeDB) break;
                this._dbObj.insertAngajator(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorA(this._cntAngajatorA, this._angajatorA);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorB(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC1(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC2(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC3(this._angajator);
                if (!this._writeDB) break;
                if (this._existsAngajatorC4) {
                    this._dbObj.insertAngajatorC4(this._angajator);
                    if (!this._writeDB) break;
                }
                this._dbObj.insertAngajatorC5(this._cntAngajatorC5, this._angajatorC5);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC6(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorC7(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorD(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE1(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE2(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE3(this._angajator);
                if (!this._writeDB) break;
                this._dbObj.insertAngajatorE4(this._angajator);
                if (!this._writeDB) break;
                if (this._existsAngajatorF1) {
                    this._dbObj.insertAngajatorF1(this._angajator);
                    if (!this._writeDB) break;
                    this._dbObj.insertAngajatorF2(this._cntAngajatorF2, this._angajatorF2);
                    if (this._writeDB) break;
                    break;
                }
                if (!this._angajator._exists_A21_1) break;
                this._angajator._F1_suma_f = this._angajator._val_A21_1;
                this._angajator._F1_suma = Long.toString(this._angajator._val_A21_1);
                this._dbObj.insertAngajatorF1(this._angajator);
                if (this._writeDB) break;
                break;
            }
            case 2: {
                if (this._status != 4) {
                    n3 = 0;
                } else {
                    this._angajatorA[this._cntAngajatorA].aggregation(0);
                }
                ++this._cntAngajatorA;
                break;
            }
            case 3: {
                if (this._status != 6) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(2);
                break;
            }
            case 4: {
                if (this._status != 8) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(3);
                break;
            }
            case 5: {
                if (this._status != 10) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(4);
                break;
            }
            case 6: {
                if (this._status != 12) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(5);
                break;
            }
            case 7: {
                if (this._status != 14) {
                    n3 = 0;
                } else {
                    this._angajator.aggregation(6);
                }
                this._existsAngajatorC4 = true;
                break;
            }
            case 8: {
                if (this._status != 16) {
                    n3 = 0;
                } else {
                    this._angajatorC5[this._cntAngajatorC5].aggregation(0);
                }
                ++this._cntAngajatorC5;
                break;
            }
            case 9: {
                if (this._status != 18) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(7);
                break;
            }
            case 10: {
                if (this._status != 20) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(8);
                break;
            }
            case 11: {
                if (this._status != 22) {
                    n3 = 0;
                } else {
                    this._angajator.aggregation(9);
                }
                this._existsAngajatorD = true;
                break;
            }
            case 12: {
                if (this._status != 24) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(10);
                break;
            }
            case 13: {
                if (this._status != 26) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(11);
                break;
            }
            case 14: {
                if (this._status != 28) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(12);
                break;
            }
            case 15: {
                if (this._status != 30) {
                    n3 = 0;
                    break;
                }
                this._angajator.aggregation(13);
                break;
            }
            case 16: {
                if (this._status != 32) {
                    n3 = 0;
                } else {
                    this._angajator.aggregation(14);
                }
                this._existsAngajatorF1 = true;
                break;
            }
            case 17: {
                if (this._status != 34) {
                    n3 = 0;
                } else {
                    this._angajatorF2[this._cntAngajatorF2].aggregation(0);
                }
                ++this._cntAngajatorF2;
                break;
            }
            case 18: {
                this._indStack = 0;
                ++this._cntAsigurat;
                if (this._status != 41 && this._status != 51 && this._status != 55 && this._status != 53) {
                    n3 = 0;
                    break;
                }
                this._asigurat.aggregation(0);
                if (!this._writeDB) break;
                this._dbObj.insertAsigurat(this._asigurat);
                if (!this._writeDB) break;
                this._dbObj.insertAsiguratCo(this._cntCoAsigurati, this._coAsigurati);
                if (!this._writeDB) break;
                if (this._asigType == 0) {
                    this._dbObj.insertAsiguratA(this._asiguratA);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratC) {
                        this._dbObj.insertAsiguratC(this._asiguratC);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratD(this._cntAsiguratD, this._asiguratD);
                    if (this._writeDB) break;
                    break;
                }
                if (this._asigType == 1) {
                    this._dbObj.insertAsiguratB1(this._cntAsiguratB1, this._asiguratB1, this._cntAsiguratB11, this._asiguratB11);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratB2) {
                        this._dbObj.insertAsiguratB2(this._asiguratB2);
                        if (!this._writeDB) break;
                    }
                    if (this._existsAsiguratB3) {
                        this._dbObj.insertAsiguratB3(this._asiguratB2);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratB4(this._asiguratB2);
                    if (!this._writeDB) break;
                    if (this._existsAsiguratC) {
                        this._dbObj.insertAsiguratC(this._asiguratC);
                        if (!this._writeDB) break;
                    }
                    this._dbObj.insertAsiguratD(this._cntAsiguratD, this._asiguratD);
                    if (this._writeDB) break;
                    break;
                }
                this._dbObj.insertAsiguratC(this._asiguratC);
                if (!this._writeDB) break;
                this._dbObj.insertAsiguratD(this._cntAsiguratD, this._asiguratD);
                if (this._writeDB) break;
                break;
            }
            case 19: {
                if (this._status != 38) {
                    n3 = 0;
                } else {
                    this._coAsigurati[this._cntCoAsigurati].aggregation(0);
                }
                ++this._cntCoAsigurati;
                break;
            }
            case 20: {
                if (this._status != 40) {
                    n3 = 0;
                    break;
                }
                this._asiguratA.aggregation(0);
                break;
            }
            case 21: {
                this._indStack = 1;
                if (this._status != 42 && this._status != 45) {
                    n3 = 0;
                } else {
                    this._asiguratB1[this._cntAsiguratB1].aggregation(0);
                }
                ++this._cntAsiguratB1;
                break;
            }
            case 22: {
                if (this._status != 44) {
                    n3 = 0;
                } else {
                    this._asiguratB11[this._cntAsiguratB11].aggregation(0);
                }
                ++this._cntAsiguratB11;
                ++this._indAsiguratB11perB1;
                break;
            }
            case 23: {
                if (this._status != 46) {
                    n3 = 0;
                    break;
                }
                this._asiguratB2.aggregation(0);
                break;
            }
            case 24: {
                if (this._status != 48) {
                    n3 = 0;
                    break;
                }
                this._asiguratB2.aggregation(1);
                break;
            }
            case 25: {
                if (this._status != 50) {
                    n3 = 0;
                    break;
                }
                this._asiguratB2.aggregation(2);
                break;
            }
            case 26: {
                if (this._status != 52) {
                    n3 = 0;
                    break;
                }
                this._asiguratC.aggregation(0);
                break;
            }
            case 27: {
                if (this._status != 54) {
                    n3 = 0;
                } else {
                    this._asiguratD[this._cntAsiguratD].aggregation(0);
                }
                ++this._cntAsiguratD;
            }
        }
        if (n3 >= 0) {
            this.addError(2, null, "", this.fillParams("lipsa sectiune obligatorie inainte de sfarsitul sectiunii '@0@'", string2), 2);
        }
        this._status = 2 * n + 1;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        String string = new String(cArray, n, n2).trim();
        if (string.length() != 0) {
            this.addError(2, null, "", this.fillParams("continut nepermis ('@0@') in sau dupa sectiunea @1@", string, this._lastTag), 2);
            return;
        }
        if (!this._tagStack[this._tagStackInd]) {
            this.addError(2, null, "", this.fillParams("continut nepermis (spatii) in sectiunea @0@", this._lastTag), 2);
            return;
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
    }

    int getErrors() {
        return this._errorStatus & 0xF;
    }

    int getWarnings() {
        return this._errorStatus & 0x10;
    }

    int hasCurrentAttributeErrors() {
        return this._errorStatus & 1;
    }

    int hasFatalErrors() {
        return this._errorStatus & 4;
    }

    int hasTechnicalErrors() {
        return this._errorStatus & 8;
    }

    void setIdAsig(String string) {
        this._idAsig = string;
    }

    String adjustString(String string) {
        return string == null ? "" : string;
    }

    String fillParams(String string, Object ... objectArray) {
        String string2 = string;
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = string2.replaceAll("@" + Integer.toString(i) + "@", (objectArray[i] == null ? "'lipsa'" : (String)objectArray[i]).trim());
        }
        return string2;
    }

    void initializeAtribList(Object object) {
        if (object == null) {
            this._emptyAttribListFlag = true;
            this._attribFullList = new HashSet();
        } else {
            this._emptyAttribListFlag = false;
            this._attribFullList = (HashSet)object;
        }
    }

    Object finalizeAttribCheck() {
        if (this._attrib.getLength() > this._effectiveAttribCount) {
            int n = this._attrib.getLength();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                String string = this._attrib.getLocalName(i);
                if (this._attribFullList.contains(string) || (bl = this._attrib.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) && (!bl || string.equals("nil") || string.equals("type") || string.equals("schemaLocation") || string.equals("noNamespaceSchemaLocation"))) continue;
                this.addError(0, string, "", this.fillParams("atribut necunoscut ('@0@') in namespace='@1@'", string, bl ? "http://www.w3.org/2001/XMLSchema-instance" : DEC_NAMESPACE));
            }
        }
        if (this._emptyAttribListFlag) {
            return this._attribFullList;
        }
        return null;
    }

    public int setDbConnection(Connection connection) {
        if (this._dbObj != null) {
            return 1;
        }
        if (connection == null) {
            return -1;
        }
        this._dbObj = new DbAccessImpl();
        if (this._dbObj.connectDB(connection) != null) {
            return -2;
        }
        this._dbObj.setValidator(this);
        return 0;
    }

    public void setOption(long l) {
        this._option = l;
        Const.LEVEL_ERR_21 = (this._option & 1L) == 0L ? Const.LEVEL_ERR_21_DEFAULT : Const.LEVEL_ERR_21_US;
    }

    public void enableDbOperation() {
        if (this._dbObj != null) {
            this._writeDB = true;
        }
    }

    public void disableDbOperation() {
        this._writeDB = false;
    }

    public long round(double d) {
        long l = Math.round(d);
        if (l == 0L && d != 0.0) {
            return 1L;
        }
        return l;
    }

    public Object getParams() {
        return this._params;
    }

    public String getSchemaNamespace() {
        return DEC_NAMESPACE;
    }

    static {
        Arrays.sort(_tags);
        _dateFormat.setLenient(false);
    }
}

