/*
 * Decompiled with CFR 0.152.
 */
package pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TextField;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import pdf.Pdf;

public abstract class PdfRoot
implements Pdf {
    private static String _errMessage = null;
    protected Document _document;
    protected String _pdfFullFileName;
    protected String _xmlAttachementName;
    protected String _zipAttachementName;
    protected PdfWriter _writer = null;
    protected float defX;
    protected float defY;
    protected float defH;
    protected float defW;
    protected float defFontS;
    public static final int B_UP = 1;
    public static final int B_BOTTOM = 2;
    public static final int B_LEFT = 4;
    public static final int B_RIGHT = 8;
    public static final int O_LEFT = 16;
    public static final int O_CENTER = 32;
    public static final int O_RIGHT = 64;
    public static final int O_BOLD = 128;
    public static final int O_ITALIC = 256;
    public static final int O_UNDERLINE = 512;
    public static final int O_INVISIBLE = 1024;
    public static final int O_BACKGROUND_LIGHT = 2048;
    public static final int O_BACKGROUND_DARK = 4096;
    public static final int O_BORDER = 15;
    protected int defOptions;
    private int eticheta = 0;

    protected void setParams(String pdfName, String xmlName, String zipName) {
        this._pdfFullFileName = pdfName;
        this._xmlAttachementName = xmlName;
        this._zipAttachementName = zipName;
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    public static String getErrorMessage() {
        return _errMessage;
    }

    protected String createDoc(boolean withImage) {
        boolean cnt = false;
        try {
            this._document = new Document(PageSize.A4);
            this._writer = PdfWriter.getInstance((Document)this._document, (OutputStream)new FileOutputStream(this._pdfFullFileName));
        }
        catch (FileNotFoundException e) {
            return "eroare acces fisier: " + e.toString();
        }
        catch (DocumentException e) {
            return "eroare acces document: " + e.toString();
        }
        catch (Throwable e) {
            return "eroare document: " + e.toString();
        }
        try {
            this._document.open();
            this._document.add((Element)new Paragraph(" "));
            this.defX = 130.0f;
            this.defY = 825.0f;
            this.defH = 13.0f;
            this.defW = 100.0f;
            this.defFontS = 12.0f;
            this.defOptions = 16;
        }
        catch (Throwable e3) {
            return "eroare scriere PDF: " + e3.toString();
        }
        if (withImage) {
            try {
                URL imageURL = this.getClass().getResource("images/sigla_anaf.jpg");
                Image img = Image.getInstance((URL)imageURL);
                img.setAbsolutePosition(35.0f, 785.0f);
                this._document.add((Element)img);
            }
            catch (Throwable ex) {
                return "eroare creare sigla ANAF: " + ex.toString();
            }
        }
        return "";
    }

    protected String finalizeDoc() {
        File file = null;
        PdfFileSpecification fs = null;
        try {
            file = new File(this._xmlAttachementName);
            fs = PdfFileSpecification.fileEmbedded((PdfWriter)this._writer, (String)file.getPath(), (String)file.getName(), null);
        }
        catch (Throwable e1) {
            return "eroare fisier XML de atasat: " + e1.toString();
        }
        try {
            this._writer.addFileAttachment("XML", fs);
        }
        catch (Throwable e) {
            return "eroare atasare fisier XML: " + e.toString();
        }
        if (this._zipAttachementName == null || this._zipAttachementName.equals("")) {
            this._document.close();
            return "";
        }
        try {
            file = new File(this._zipAttachementName);
            fs = PdfFileSpecification.fileEmbedded((PdfWriter)this._writer, (String)file.getPath(), (String)file.getName(), null);
        }
        catch (Throwable e1) {
            return "eroare fisier ZIP de atasat: " + e1.toString();
        }
        try {
            this._writer.addFileAttachment("ZIP", fs);
            this._document.close();
        }
        catch (Throwable e) {
            return "eroare atasare fisier XML: " + e.toString();
        }
        return "";
    }

    protected void newPage(float minRequired) {
        if (this.defY < minRequired) {
            this._document.newPage();
            this.defY = 825.0f;
        }
    }

    protected void newPage() {
        this._document.newPage();
        this.defY = 800.0f;
    }

    protected float drawParag(String value, Object ... list) throws DocumentException {
        float x = this.defX;
        float y = this.defY;
        float h = this.defH;
        float w = this.defW;
        float fSize = this.defFontS;
        int options = this.defOptions;
        if (list != null) {
            int val = list.length;
            if (val > 0 && list[0] != null) {
                x = (float)((Double)list[0]).doubleValue();
            }
            if (val > 1 && list[1] != null) {
                y = (float)((Double)list[1]).doubleValue();
            }
            if (val > 2 && list[2] != null) {
                w = (float)((Double)list[2]).doubleValue();
            }
            if (val > 3 && list[3] != null) {
                h = (float)((Double)list[3]).doubleValue();
            }
            if (val > 4 && list[4] != null) {
                options = (Integer)list[4];
            }
            if (val > 5 && list[5] != null) {
                fSize = (float)((Double)list[5]).doubleValue();
            }
        }
        float yInit = this.defY;
        y -= h;
        int style = 0;
        if ((options & 0x100) != 0) {
            style |= 2;
        }
        if ((options & 0x80) != 0) {
            style |= 1;
        }
        ColumnText.showTextAligned((PdfContentByte)this._writer.getDirectContent(), (int)0, (Phrase)new Phrase(value, new Font(Font.FontFamily.TIMES_ROMAN, fSize, style)), (float)(x + 1.0f), (float)(y + fSize / 4.0f), (float)0.0f);
        if ((options & 0x180F) != 0) {
            Rectangle rect = new Rectangle(x, y, x + w, y + h);
            rect.setBorderWidth(0.5f);
            rect.setBorderColor(BaseColor.BLACK);
            rect.setBorder(options & 0xF);
            if ((options & 0x800) != 0) {
                rect.setBackgroundColor(BaseColor.LIGHT_GRAY);
            } else if ((options & 0x1000) != 0) {
                rect.setBackgroundColor(BaseColor.DARK_GRAY);
            }
            this._document.add((Element)rect);
        }
        this.defY = y;
        return yInit;
    }

    protected float drawField(String name, String value, Object ... list) throws DocumentException, IOException {
        float x = this.defX;
        float y = this.defY;
        float h = this.defH;
        float w = this.defW;
        float fSize = this.defFontS;
        int options = this.defOptions;
        if (list != null) {
            int val = list.length;
            if (val > 0 && list[0] != null) {
                x = (float)((Double)list[0]).doubleValue();
            }
            if (val > 1 && list[1] != null) {
                y = (float)((Double)list[1]).doubleValue();
            }
            if (val > 2 && list[2] != null) {
                w = (float)((Double)list[2]).doubleValue();
            }
            if (val > 3 && list[3] != null) {
                h = (float)((Double)list[3]).doubleValue();
            }
            if (val > 4 && list[4] != null) {
                options = (Integer)list[4];
            }
            if (val > 5 && list[5] != null) {
                fSize = (float)((Double)list[5]).doubleValue();
            }
        }
        if ((options & 0x180F) != 0) {
            Rectangle rect = new Rectangle(x, y, x + w, y - h);
            rect.setBorderWidth(1.0f);
            rect.setBorderColor(BaseColor.BLACK);
            rect.setBorder(options & 0xF);
            if ((options & 0x800) != 0) {
                rect.setBackgroundColor(BaseColor.LIGHT_GRAY);
            } else if ((options & 0x1000) != 0) {
                rect.setBackgroundColor(BaseColor.DARK_GRAY);
            }
            this._document.add((Element)rect);
        }
        TextField field = new TextField(this._writer, new Rectangle(x, y + fSize / 8.0f, x + w, y - h + fSize / 8.0f), name);
        field.setText(value);
        field.setFontSize(fSize);
        field.setAlignment((options & 0x10) != 0 ? 0 : ((options & 0x40) != 0 ? 2 : 1));
        field.setOptions(4097);
        if ((options & 0x400) != 0) {
            field.setVisibility(1);
        }
        this._writer.addAnnotation((PdfAnnotation)field.getTextField());
        this.defY = y - h;
        return y;
    }

    private double drawLine(int[] opt, double[] sizeFont, double[] definitieCelule, Object ... texte) throws Throwable {
        return this.drawLine(0, null, this.defH, opt, sizeFont, definitieCelule, texte);
    }

    private double drawLine(int nrRanduri, Double pozitieY, double hCelula, int[] opt, double[] sizeFont, double[] definitieCelule, Object ... texte) throws Throwable {
        int nrParametri = texte.length;
        int cnt = nrRanduri;
        double yReturn = 0.0;
        String[][] lines = new String[nrParametri][];
        for (int i = 0; i < nrParametri; ++i) {
            lines[i] = ((String)texte[i]).split("\\|");
            cnt = Math.max(cnt, lines[i].length);
        }
        int[] cnt1 = new int[nrParametri];
        for (int i = 0; i < nrParametri; ++i) {
            cnt1[i] = (cnt - lines[i].length + 1) / 2;
        }
        double y = 0.0;
        int opt1 = 0;
        int opt2 = 0;
        for (int i = 0; i < cnt; ++i) {
            int j;
            if (cnt == 1) {
                y = this.drawParag("", definitieCelule[0], pozitieY, definitieCelule[nrParametri] - definitieCelule[0], hCelula, 0);
                yReturn = pozitieY == null ? y : (y = pozitieY.doubleValue());
            } else if (i == 0) {
                y = this.drawParag("", definitieCelule[0], pozitieY, definitieCelule[nrParametri] - definitieCelule[0], hCelula, 0);
                yReturn = pozitieY == null ? y : (y = pozitieY.doubleValue());
            } else {
                y = this.drawParag("", definitieCelule[0], null, definitieCelule[nrParametri] - definitieCelule[0], hCelula, 0);
            }
            for (j = 0; j < texte.length; ++j) {
                ++this.eticheta;
                if (i >= cnt1[j] && i - cnt1[j] < lines[j].length) {
                    this.drawField(Integer.toString(this.eticheta), lines[j][i - cnt1[j]], definitieCelule[j], y, definitieCelule[j + 1] - definitieCelule[j], hCelula, opt[j] & 0xFFFFFFF0, sizeFont[j]);
                    continue;
                }
                this.drawParag("", definitieCelule[j], y, definitieCelule[j + 1] - definitieCelule[j], hCelula, opt[j] & 0xFFFFFFF0);
            }
            for (j = 0; j < texte.length; ++j) {
                opt1 = opt[j] & 0xFFFFFFF0 & 0x1800;
                opt2 = ~(opt[j] & 0xF);
                if (cnt == 1) {
                    this.drawParag("", definitieCelule[j], y, definitieCelule[j + 1] - definitieCelule[j], hCelula, opt2 & 0xF | opt1);
                    continue;
                }
                if (i == 0) {
                    this.drawParag("", definitieCelule[j], y, definitieCelule[j + 1] - definitieCelule[j], hCelula, opt2 & 0xD | opt1);
                    continue;
                }
                if (i == cnt - 1) {
                    this.drawParag("", definitieCelule[j], y, definitieCelule[j + 1] - definitieCelule[j], hCelula, opt2 & 0xE | opt1);
                    continue;
                }
                this.drawParag("", definitieCelule[j], y, definitieCelule[j + 1] - definitieCelule[j], hCelula, opt2 & 0xC | opt1);
            }
        }
        return yReturn;
    }
}

