/*
 * Decompiled with CFR 0.152.
 */
package ui;

import ajutor.Ajutor;
import dec.LogTrace;
import dec.Options;
import dec.Params;
import general.Integrator;
import general.Main;
import istoric.Istoric;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import pdf.Sign;
import ui.CertificateChooser;

public class DUKFrame
extends JFrame
implements CertificateChooser,
Runnable {
    private JButton btnAccept;
    private JButton btnCancel;
    private JButton btnClose;
    private JButton btnGetFileName;
    private JButton btnKeepDec;
    private JButton btnKeepOldValues;
    private JButton btnOK;
    private JButton btnPDF;
    private JButton btnSign;
    private JButton btnUnInstall;
    private JButton btnUnInstallAll;
    private JButton btnUnInstallDec;
    private JButton btnUnInstallNothing;
    private JButton btnValidation;
    private JCheckBox chkAuthentication;
    private JCheckBox chkAuto;
    private JCheckBox chkNewDeclarations;
    private JCheckBox chkOffLine;
    private JCheckBox chkUserPwd;
    private JComboBox cmbCardType;
    private JComboBox cmbCertificates;
    private JComboBox cmbDecType;
    private JComboBox cmbOptions;
    private JFileChooser ctlFileChooser;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblCardType;
    private JLabel lblEndDate;
    private JLabel lblFurnizor;
    private JLabel lblHelp;
    private JLabel lblKept;
    private JLabel lblNume;
    private JLabel lblOptions;
    private JLabel lblPin;
    private JLabel lblSerialNumber;
    private JLabel lblStartDate;
    private JLabel lblUnInstallMain;
    private JLabel lblUnInstalled;
    private JList lstKept;
    private JList lstUnInstalled;
    private JMenuItem mniExit;
    private JMenuItem mniHelp;
    private JMenuItem mniHistory;
    private JMenuItem mniOptions;
    private JMenuItem mniUnInstallDec;
    private JMenu mnuFile;
    private JMenu mnuHelp;
    private JMenuBar mnuMain;
    private JMenu mnuTools;
    private JProgressBar pgrBar;
    private JScrollPane pnlResults;
    private JTextField txtDomain;
    private JTextField txtEndDate;
    private JTextField txtFileName;
    private JTextField txtFurnizor;
    private JTextField txtJavaStart;
    private JTextField txtJavaVersion;
    private JTextField txtNume;
    private JPasswordField txtPin;
    private JTextField txtProxyIP;
    private JTextField txtProxyPort;
    private JPasswordField txtPwd;
    private JTextArea txtResults;
    private JTextField txtSerialNumber;
    private JTextField txtStartDate;
    private JTextField txtUser;
    private JDialog wndChooseCertificate;
    private JDialog wndOptions;
    private JDialog wndUnInstallDec;
    public static String _newLine = System.getProperty("line.separator");
    private static final String _AUTO_DETECT = "*autoDetect";
    private static final String _title = "DUKIntegrator - versiune: # - % - versiune validator: ";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy");
    private String _configPath = "";
    private String _rootPath = "";
    private String _xmlFile = "";
    private String _errFile = "";
    private boolean _flag = true;
    private String _decType = null;
    private String _defDecl = null;
    private Integrator _integrator = null;
    public String _urlVersiuni = null;
    public String _offLine = null;
    public String _javaStartPrefix = null;
    public String _javaVersion = null;
    public String _user = null;
    public String _pwd = null;
    public String _domain = null;
    public String _authentication = null;
    public String _ignoraDeclaratiiNoi = null;
    public String _proxy = null;
    public String _proxyIP = null;
    public String _proxyPort = null;
    private int _processingType;
    private boolean _stopProcessing = false;
    private boolean _getEnableOptions;
    private boolean _getEnableSign;
    private int _zipOption;
    private FileFilter _crtFilter = null;
    private DefaultListModel _lstKeepModel = null;
    private DefaultListModel _lstUnInstalledModel = null;
    private Ajutor _frmAjutor = null;
    private Istoric _frmIstorie = null;
    private String[] _decList = null;

    public DUKFrame(String rootPath, String configPath, String xmlFile, String errFile) {
        this.initComponents();
        this._configPath = configPath;
        this._rootPath = rootPath;
        LogTrace.init((String)(this._configPath + "emergency.log"), (String)(this._configPath + "emergency.trc"), (int)0, (int)100, (boolean)true);
        this._integrator = new Integrator();
        this._integrator.setChooser(this);
        this._integrator.setConfigPath(this._configPath);
        this._xmlFile = xmlFile;
        this._errFile = errFile;
        this.txtFileName.setText(this._xmlFile);
        this.setVisibleValidationButton();
        this.populateCardList();
        this.getConfigDefaults();
        DefaultListModel<String> defList = new DefaultListModel<String>();
        if (Main.createVersionFile(this._integrator.getValidator(), this._integrator.getPdfSuperCreator(), this._configPath, 1) < 0) {
            this.cmbDecType.setModel(new DefaultComboBoxModel());
            this.lstKept.setModel(defList);
            this._decList = new String[0];
        } else {
            this._decList = Main.getDeclarationList(this._configPath);
            this.cmbDecType.setModel(new DefaultComboBoxModel<String>(this._decList));
            for (String dec : this._decList) {
                defList.addElement(dec);
            }
            this.lstKept.setModel(defList);
        }
        if (this.lstKept.getModel().getSize() != 0) {
            this.lstKept.setSelectedIndex(0);
        }
        this.lstUnInstalled.setModel(new DefaultListModel());
        if (this.cmbDecType.getModel().getSize() != 0) {
            if (this._defDecl != null) {
                this.cmbDecType.setSelectedItem(this._defDecl);
            }
            this._decType = this.cmbDecType.getSelectedItem().toString();
            this._integrator.setDeclType(this._decType);
            this._zipOption = this._integrator.getPdfZipOption();
            this.fillOptions();
            this.setTitle(_title.replaceAll("%", this._decType).replaceAll("#", "1.2.13.3.3") + this._integrator.getLastVersion() + " / " + this._integrator.getPdfLastVersion());
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "Nu aveti nicio declaratie instalata.");
        }
        this.wndChooseCertificate.setVisible(false);
        this.wndChooseCertificate.getRootPane().setDefaultButton(this.btnOK);
        this.wndChooseCertificate.setDefaultCloseOperation(0);
        this.wndChooseCertificate.setLocationRelativeTo(this);
        this.wndChooseCertificate.pack();
        this.wndUnInstallDec.setVisible(false);
        this.wndUnInstallDec.getRootPane().setDefaultButton(this.btnClose);
        this.wndUnInstallDec.setDefaultCloseOperation(0);
        this.wndUnInstallDec.setLocationRelativeTo(this);
        this.wndUnInstallDec.pack();
        this.wndOptions.setVisible(false);
        this.wndOptions.getRootPane().setDefaultButton(this.btnKeepOldValues);
        this.wndOptions.setDefaultCloseOperation(0);
        this.wndOptions.setLocationRelativeTo(this);
        this.wndOptions.pack();
        this.pgrBar.setVisible(false);
        this.btnCancel.setVisible(false);
    }

    private void initComponents() {
        this.ctlFileChooser = new JFileChooser();
        this.wndChooseCertificate = new JDialog();
        this.jLabel1 = new JLabel();
        this.btnOK = new JButton();
        this.cmbCertificates = new JComboBox();
        this.lblFurnizor = new JLabel();
        this.lblNume = new JLabel();
        this.lblStartDate = new JLabel();
        this.lblEndDate = new JLabel();
        this.lblSerialNumber = new JLabel();
        this.txtFurnizor = new JTextField();
        this.txtNume = new JTextField();
        this.txtStartDate = new JTextField();
        this.txtEndDate = new JTextField();
        this.txtSerialNumber = new JTextField();
        this.wndUnInstallDec = new JDialog();
        this.lblUnInstallMain = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstKept = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.lstUnInstalled = new JList();
        this.btnUnInstall = new JButton();
        this.lblKept = new JLabel();
        this.lblUnInstalled = new JLabel();
        this.btnUnInstallAll = new JButton();
        this.btnUnInstallNothing = new JButton();
        this.btnUnInstallDec = new JButton();
        this.btnKeepDec = new JButton();
        this.btnClose = new JButton();
        this.wndOptions = new JDialog();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.chkUserPwd = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.txtUser = new JTextField();
        this.txtPwd = new JPasswordField();
        this.jLabel6 = new JLabel();
        this.txtProxyIP = new JTextField();
        this.jLabel7 = new JLabel();
        this.txtProxyPort = new JTextField();
        this.chkAuto = new JCheckBox();
        this.chkNewDeclarations = new JCheckBox();
        this.btnAccept = new JButton();
        this.btnKeepOldValues = new JButton();
        this.chkAuthentication = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.txtDomain = new JTextField();
        this.chkOffLine = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.txtJavaStart = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.txtJavaVersion = new JTextField();
        this.jLabel12 = new JLabel();
        this.lblHelp = new JLabel();
        this.txtFileName = new JTextField();
        this.btnGetFileName = new JButton();
        this.btnValidation = new JButton();
        this.btnPDF = new JButton();
        this.btnSign = new JButton();
        this.txtPin = new JPasswordField();
        this.lblPin = new JLabel();
        this.cmbCardType = new JComboBox();
        this.lblCardType = new JLabel();
        this.jLabel2 = new JLabel();
        this.cmbDecType = new JComboBox();
        this.lblOptions = new JLabel();
        this.cmbOptions = new JComboBox();
        this.jPanel4 = new JPanel();
        this.pnlResults = new JScrollPane();
        this.txtResults = new JTextArea();
        this.pgrBar = new JProgressBar();
        this.btnCancel = new JButton();
        this.mnuMain = new JMenuBar();
        this.mnuFile = new JMenu();
        this.mniExit = new JMenuItem();
        this.mnuTools = new JMenu();
        this.mniUnInstallDec = new JMenuItem();
        this.mniOptions = new JMenuItem();
        this.mnuHelp = new JMenu();
        this.mniHelp = new JMenuItem();
        this.mniHistory = new JMenuItem();
        this.wndChooseCertificate.setTitle("Alegeti un certficat pt. semnare");
        this.wndChooseCertificate.setModal(true);
        this.wndChooseCertificate.setResizable(false);
        this.jLabel1.setText("Token cu mai multe certificate. Selectati certificatul dorit");
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnOKActionPerformed(evt);
            }
        });
        this.cmbCertificates.setAutoscrolls(true);
        this.cmbCertificates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.cmbCertificatesActionPerformed(evt);
            }
        });
        this.lblFurnizor.setText("Furnizor:");
        this.lblNume.setText("Nume:");
        this.lblStartDate.setText("StartValabilitate:");
        this.lblEndDate.setText("EndValabilitate:");
        this.lblSerialNumber.setText("SerialNumber:");
        this.txtFurnizor.setEditable(false);
        this.txtNume.setEditable(false);
        this.txtStartDate.setEditable(false);
        this.txtEndDate.setEditable(false);
        this.txtSerialNumber.setEditable(false);
        GroupLayout wndChooseCertificateLayout = new GroupLayout(this.wndChooseCertificate.getContentPane());
        this.wndChooseCertificate.getContentPane().setLayout(wndChooseCertificateLayout);
        wndChooseCertificateLayout.setHorizontalGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndChooseCertificateLayout.createSequentialGroup().addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndChooseCertificateLayout.createSequentialGroup().addContainerGap().addComponent(this.cmbCertificates, 0, 441, Short.MAX_VALUE)).addGroup(wndChooseCertificateLayout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.jLabel1, -2, 272, -2))).addContainerGap()).addGroup(wndChooseCertificateLayout.createSequentialGroup().addContainerGap().addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndChooseCertificateLayout.createSequentialGroup().addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblSerialNumber, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblEndDate, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblStartDate, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblNume, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblFurnizor, GroupLayout.Alignment.LEADING, -1, 81, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtFurnizor, -1, 350, Short.MAX_VALUE).addComponent(this.txtNume, -1, 350, Short.MAX_VALUE).addComponent(this.txtStartDate, -1, 350, Short.MAX_VALUE).addComponent(this.txtEndDate, -1, 350, Short.MAX_VALUE).addComponent(this.txtSerialNumber, -1, 350, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, wndChooseCertificateLayout.createSequentialGroup().addGap(0, 206, Short.MAX_VALUE).addComponent(this.btnOK).addGap(196, 196, 196)))));
        wndChooseCertificateLayout.setVerticalGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndChooseCertificateLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(28, 28, 28).addComponent(this.cmbCertificates, -2, -1, -2).addGap(18, 18, 18).addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFurnizor).addComponent(this.txtFurnizor, -2, 17, -2)).addGap(11, 11, 11).addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblNume).addComponent(this.txtNume, -2, 17, -2)).addGap(11, 11, 11).addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStartDate).addComponent(this.txtStartDate, -2, 17, -2)).addGap(11, 11, 11).addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEndDate).addComponent(this.txtEndDate, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndChooseCertificateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSerialNumber).addComponent(this.txtSerialNumber, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addComponent(this.btnOK).addContainerGap()));
        this.wndUnInstallDec.setTitle("Dezinstalare declaratii (o singura data pe sesiune)");
        this.wndUnInstallDec.setModal(true);
        this.wndUnInstallDec.setResizable(false);
        this.wndUnInstallDec.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DUKFrame.this.wndUnInstallDecWindowClosing(evt);
            }
        });
        this.lblUnInstallMain.setText("Dezinstalarea declaratiilor selectate este efectiva dupa ce terminati programul");
        this.lstKept.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lstKept);
        this.lstUnInstalled.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.lstUnInstalled);
        this.btnUnInstall.setText("Dezinstaleaza");
        this.btnUnInstall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnUnInstallActionPerformed(evt);
            }
        });
        this.lblKept.setText("Declaratii ramase instalate");
        this.lblUnInstalled.setText("Declaratii de dezinstalat");
        this.btnUnInstallAll.setText(">>");
        this.btnUnInstallAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnUnInstallAllActionPerformed(evt);
            }
        });
        this.btnUnInstallNothing.setText("<<");
        this.btnUnInstallNothing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnUnInstallNothingActionPerformed(evt);
            }
        });
        this.btnUnInstallDec.setText(">");
        this.btnUnInstallDec.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnUnInstallDecActionPerformed(evt);
            }
        });
        this.btnKeepDec.setText("<");
        this.btnKeepDec.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnKeepDecActionPerformed(evt);
            }
        });
        this.btnClose.setText("Inchide");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnCloseActionPerformed(evt);
            }
        });
        GroupLayout wndUnInstallDecLayout = new GroupLayout(this.wndUnInstallDec.getContentPane());
        this.wndUnInstallDec.getContentPane().setLayout(wndUnInstallDecLayout);
        wndUnInstallDecLayout.setHorizontalGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndUnInstallDecLayout.createSequentialGroup().addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndUnInstallDecLayout.createSequentialGroup().addGap(27, 27, 27).addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblUnInstallMain).addGroup(wndUnInstallDecLayout.createSequentialGroup().addComponent(this.lblKept).addGap(146, 146, 146).addComponent(this.lblUnInstalled)))).addGroup(wndUnInstallDecLayout.createSequentialGroup().addContainerGap().addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnUnInstall).addComponent(this.jScrollPane1, -2, 168, -2)).addGap(18, 18, 18).addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnKeepDec, 0, 0, Short.MAX_VALUE).addComponent(this.btnUnInstallNothing, 0, 0, Short.MAX_VALUE).addComponent(this.btnUnInstallAll, -1, -1, Short.MAX_VALUE).addComponent(this.btnUnInstallDec, -2, 55, -2)).addGap(18, 18, 18).addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnClose).addComponent(this.jScrollPane2, -2, 156, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        wndUnInstallDecLayout.linkSize(0, this.btnKeepDec, this.btnUnInstallAll, this.btnUnInstallDec, this.btnUnInstallNothing);
        wndUnInstallDecLayout.linkSize(0, this.btnClose, this.btnUnInstall);
        wndUnInstallDecLayout.linkSize(0, this.jScrollPane1, this.jScrollPane2);
        wndUnInstallDecLayout.setVerticalGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndUnInstallDecLayout.createSequentialGroup().addContainerGap().addComponent(this.lblUnInstallMain).addGap(40, 40, 40).addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblKept).addComponent(this.lblUnInstalled)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndUnInstallDecLayout.createSequentialGroup().addComponent(this.btnUnInstallAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnUnInstallNothing).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnUnInstallDec).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnKeepDec)).addComponent(this.jScrollPane1, -1, 210, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 210, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, -2).addGroup(wndUnInstallDecLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnUnInstall).addComponent(this.btnClose)).addContainerGap()));
        this.wndOptions.setTitle("Optiuni download");
        this.wndOptions.setModal(true);
        this.wndOptions.setResizable(false);
        this.wndOptions.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DUKFrame.this.wndOptionsWindowClosing(evt);
            }
        });
        this.jLabel3.setText("Optiunile selectate vor fi inscrise in fisierul de configurare si vor deveni active la urmatoarea lansare DUKIntegrator");
        this.jLabel5.setText("Parola:");
        this.chkUserPwd.setText("Autentificare user/pwd pt. proxy");
        this.chkUserPwd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.chkUserPwdActionPerformed(evt);
            }
        });
        this.jLabel4.setText("User:");
        this.jLabel6.setText("IP proxy:");
        this.jLabel7.setText("Port proxy:");
        this.chkAuto.setText("Incearca determinare automata IP/port proxy");
        this.chkNewDeclarations.setText("Vreau sa stiu daca apar declaratii/documente noi");
        this.btnAccept.setText("OK");
        this.btnAccept.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnAcceptActionPerformed(evt);
            }
        });
        this.btnKeepOldValues.setText("Anuleaza");
        this.btnKeepOldValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnKeepOldValuesActionPerformed(evt);
            }
        });
        this.chkAuthentication.setText("Metoda alternativa de autentificare");
        this.jLabel8.setText("Domeniu:");
        this.chkOffLine.setText("functionare off line");
        this.chkOffLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.chkOffLineActionPerformed(evt);
            }
        });
        this.jLabel9.setText("start java (ex: java -Xmx1024M)");
        this.jLabel10.setText("(prin lipsa se lanseaza cu parametri impliciti)");
        this.jLabel11.setText("versiune java (ex: -version:1.6)");
        this.jLabel12.setText("(prin lipsa se lanseaza versiunea java implicita)");
        GroupLayout wndOptionsLayout = new GroupLayout(this.wndOptions.getContentPane());
        this.wndOptions.getContentPane().setLayout(wndOptionsLayout);
        wndOptionsLayout.setHorizontalGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndOptionsLayout.createSequentialGroup().addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndOptionsLayout.createSequentialGroup().addContainerGap().addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndOptionsLayout.createSequentialGroup().addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkUserPwd).addGroup(wndOptionsLayout.createSequentialGroup().addGap(42, 42, 42).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkAuthentication).addGroup(wndOptionsLayout.createSequentialGroup().addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel8, -2, 53, -2)).addGap(14, 14, 14).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtPwd).addComponent(this.txtUser).addComponent(this.txtDomain, -2, 154, -2)).addGap(33, 33, 33).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.chkNewDeclarations).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -2, 217, -2).addComponent(this.chkOffLine).addComponent(this.jLabel9, -2, 186, -2).addComponent(this.txtJavaVersion, -2, 157, -2).addComponent(this.txtJavaStart, -2, 260, -2).addComponent(this.jLabel11, -2, 202, -2).addComponent(this.jLabel12, -2, 235, -2)))))).addGroup(wndOptionsLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtProxyPort, -2, 81, -2).addComponent(this.txtProxyIP, -2, 186, -2))).addComponent(this.chkAuto)).addGap(0, 0, Short.MAX_VALUE)).addGroup(wndOptionsLayout.createSequentialGroup().addGap(91, 91, 91).addComponent(this.btnAccept, -2, 75, -2).addGap(153, 153, 153).addComponent(this.btnKeepOldValues, -2, 105, -2).addGap(114, 114, 114)))).addGroup(wndOptionsLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        wndOptionsLayout.linkSize(0, this.btnAccept, this.btnKeepOldValues);
        wndOptionsLayout.setVerticalGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndOptionsLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkAuto).addComponent(this.chkNewDeclarations)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wndOptionsLayout.createSequentialGroup().addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtProxyIP, -2, -1, -2).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.txtProxyPort, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.chkUserPwd).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.txtUser)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.txtPwd)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.txtDomain, -2, -1, -2))).addGroup(wndOptionsLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.chkOffLine).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtJavaStart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addGap(17, 17, 17).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtJavaVersion, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel12))).addGap(13, 13, 13).addComponent(this.chkAuthentication).addGap(18, 18, 18).addGroup(wndOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAccept).addComponent(this.btnKeepOldValues)).addGap(32, 32, 32)));
        this.setDefaultCloseOperation(3);
        this.setTitle("Procesare XML");
        this.setName("frmMain");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DUKFrame.this.formWindowClosing(evt);
            }
        });
        this.lblHelp.setText("introduceti nume fisier XML sau nume folder (pt. a prelucra toate fisierele XML din el) sau folositi butonul <Alege fisiere>");
        this.txtFileName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DUKFrame.this.txtFileNameKeyReleased(evt);
            }
        });
        this.btnGetFileName.setText("Alege fisiere");
        this.btnGetFileName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnGetFileNameMouseClicked(evt);
            }
        });
        this.btnValidation.setText("Validare");
        this.btnValidation.setEnabled(false);
        this.btnValidation.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnValidationMouseClicked(evt);
            }
        });
        this.btnPDF.setText("Validare + creare PDF");
        this.btnPDF.setEnabled(false);
        this.btnPDF.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnPDFMouseClicked(evt);
            }
        });
        this.btnSign.setText("Validare + creare PDF semnat");
        this.btnSign.setEnabled(false);
        this.btnSign.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DUKFrame.this.btnSignMouseClicked(evt);
            }
        });
        this.txtPin.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                DUKFrame.this.txtPinKeyReleased(evt);
            }
        });
        this.lblPin.setText("introduceti pinul pentru semnare:");
        this.cmbCardType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.cmbCardTypeActionPerformed(evt);
            }
        });
        this.lblCardType.setText("selectati tipul de Smart Card");
        this.jLabel2.setText("alegeti tipul declaratiei");
        this.cmbDecType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbDecType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.cmbDecTypeActionPerformed(evt);
            }
        });
        this.lblOptions.setHorizontalAlignment(0);
        this.lblOptions.setText("alegeti optiuni validare");
        this.cmbOptions.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DUKFrame.this.cmbOptionsItemStateChanged(evt);
            }
        });
        this.txtResults.setColumns(20);
        this.txtResults.setEditable(false);
        this.txtResults.setFont(new Font("Times New Roman", 0, 12));
        this.txtResults.setLineWrap(true);
        this.txtResults.setRows(5);
        this.pnlResults.setViewportView(this.txtResults);
        this.btnCancel.setText("Anulare");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.btnCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.pgrBar, -2, 460, -2).addGap(18, 18, 18).addComponent(this.btnCancel, -1, 115, Short.MAX_VALUE)).addComponent(this.pnlResults, -1, 593, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.pnlResults, -1, 390, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pgrBar, -1, -1, Short.MAX_VALUE).addComponent(this.btnCancel, -2, 16, -2))));
        this.mnuFile.setText("Fisier");
        this.mniExit.setText("Terminare");
        this.mniExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.mniExitActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mniExit);
        this.mnuMain.add(this.mnuFile);
        this.mnuTools.setText("Unelte");
        this.mniUnInstallDec.setText("Dezinstalare declaratii");
        this.mniUnInstallDec.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.mniUnInstallDecActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mniUnInstallDec);
        this.mniOptions.setText("Optiuni download");
        this.mniOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.mniOptionsActionPerformed(evt);
            }
        });
        this.mnuTools.add(this.mniOptions);
        this.mnuMain.add(this.mnuTools);
        this.mnuHelp.setText("Ajutor");
        this.mniHelp.setText("Ajutor");
        this.mniHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.mniHelpActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mniHelp);
        this.mniHistory.setText("Istoria versiunilor");
        this.mniHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DUKFrame.this.mniHistoryActionPerformed(evt);
            }
        });
        this.mnuHelp.add(this.mniHistory);
        this.mnuMain.add(this.mnuHelp);
        this.setJMenuBar(this.mnuMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.lblHelp, -1, 583, Short.MAX_VALUE).addContainerGap(20, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.txtFileName, -1, 494, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGetFileName).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbCardType, -2, 186, -2).addComponent(this.lblCardType, -2, 182, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtPin).addComponent(this.lblPin, -2, 163, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 12, Short.MAX_VALUE).addComponent(this.btnSign, -2, 222, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cmbDecType, -2, 112, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbOptions, 0, 239, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnValidation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnPDF, -2, 139, -2))).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 115, -2).addGap(18, 18, 18).addComponent(this.lblOptions, -2, 216, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblHelp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtFileName, -2, -1, -2).addComponent(this.btnGetFileName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lblOptions)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPDF).addComponent(this.btnValidation).addComponent(this.cmbDecType, -2, -1, -2).addComponent(this.cmbOptions, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPin).addComponent(this.lblCardType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSign).addComponent(this.txtPin, -2, -1, -2).addComponent(this.cmbCardType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    public Sign.CertAlias chooseCertificate(List coll) {
        DefaultComboBoxModel cmbModel = new DefaultComboBoxModel();
        for (Object cert : coll) {
            cmbModel.addElement(cert);
        }
        this.cmbCertificates.setModel(cmbModel);
        this.changeStatusCombo();
        this.wndChooseCertificate.setVisible(true);
        return (Sign.CertAlias)this.cmbCertificates.getSelectedItem();
    }

    private void populateCardList() {
        if (this._configPath.equals("")) {
            return;
        }
        File cfg = new File(this._configPath);
        if (!cfg.isDirectory()) {
            return;
        }
        String[] cfgList = cfg.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".cfg");
            }
        });
        if (cfgList == null || cfgList.length == 0) {
            return;
        }
        this.cmbCardType.addItem(_AUTO_DETECT);
        for (int i = 0; i < cfgList.length; ++i) {
            this.cmbCardType.addItem(cfgList[i].substring(0, cfgList[i].length() - 4));
        }
        this.cmbCardType.setSelectedIndex(0);
    }

    private int validateXML(String fileName) {
        try {
            int returns = this._integrator.parseDocument(fileName, null);
            this.txtResults.append(this._integrator.getFinalMessage());
            return returns;
        }
        catch (Throwable e) {
            this.txtResults.append("Eroare de deployment!" + _newLine);
            this.txtResults.append("       mesaj: " + e.toString() + _newLine);
            return -2;
        }
    }

    private int pdfCreation(String fileName) {
        int ret = 0;
        try {
            ret = this._integrator.pdfCreation(fileName, null, null, null);
            this.txtResults.append(this._integrator.getFinalMessage());
            return ret;
        }
        catch (Throwable e) {
            this.txtResults.append("Eroare de deployment!" + _newLine);
            this.txtResults.append("       mesaj: " + e.toString() + _newLine);
            return -2;
        }
    }

    private int pdfSigning(String fileName) {
        int ret = 0;
        try {
            String smartCard = (String)this.cmbCardType.getSelectedItem();
            if (!smartCard.equals(_AUTO_DETECT)) {
                ret = this._integrator.signPdf(fileName, null, null, null, this.txtPin.getText(), smartCard);
                String msg = this._integrator.getFinalMessage();
                this.txtResults.append(msg);
                return ret;
            }
            for (int i = 0; i < this.cmbCardType.getModel().getSize(); ++i) {
                smartCard = (String)this.cmbCardType.getModel().getElementAt(i);
                if (smartCard.equals(_AUTO_DETECT)) continue;
                ret = this._integrator.signPdf(fileName, null, null, null, this.txtPin.getText(), smartCard);
                String msg = this._integrator.getFinalMessage();
                if (ret < 0) continue;
                this.txtResults.append(msg);
                this.cmbCardType.setSelectedIndex(i);
                return 0;
            }
            this.txtResults.append("Nu am putut detecta tipul SmartCardului!" + _newLine);
            this.txtResults.append("       Fie este un tip nou, necunoscut, fie pinul introdus nu este corect" + _newLine);
            return ret;
        }
        catch (Throwable e) {
            this.txtResults.append("Eroare de deployment!" + _newLine);
            this.txtResults.append("       mesaj: " + e.toString() + _newLine);
            return -2;
        }
    }

    private void enableUI(boolean flag) {
        this.cmbCardType.setEnabled(flag);
        this.cmbDecType.setEnabled(flag);
        this.btnValidation.setEnabled(flag);
        this.btnPDF.setEnabled(flag);
        this.txtPin.setEnabled(flag);
        this.txtFileName.setEnabled(flag);
        this.btnGetFileName.setEnabled(flag);
        if (!flag) {
            this._getEnableOptions = this.cmbOptions.isEnabled();
            this._getEnableSign = this.btnSign.isEnabled();
            this.cmbOptions.setEnabled(flag);
            this.btnSign.setEnabled(flag);
        } else {
            this.cmbOptions.setEnabled(this._getEnableOptions);
            this.btnSign.setEnabled(this._getEnableSign);
        }
    }

    private void enableUIProgBar(boolean flag, int max) {
        this.pgrBar.setVisible(!flag);
        this.btnCancel.setVisible(!flag);
        this._stopProcessing = flag;
        if (!flag) {
            this.pgrBar.setMinimum(0);
            this.pgrBar.setMaximum(max);
            this.pgrBar.setValue(0);
        }
    }

    private void processFiles(int type) {
        this._processingType = type;
        this.enableUI(false);
        Thread th = new Thread(this);
        th.start();
    }

    public void run() {
        int ret = 0;
        File file = new File(this._xmlFile);
        File[] fileList = null;
        if (file.isDirectory()) {
            try {
                fileList = file.listFiles(this._crtFilter);
            }
            catch (Throwable ex) {
                fileList = null;
            }
            this.enableUIProgBar(false, fileList.length);
            for (int i = 0; i < fileList.length && !this._stopProcessing; ++i) {
                if (fileList[i].isDirectory()) continue;
                switch (this._processingType) {
                    case 0: {
                        ret = this.validateXML(fileList[i].getPath());
                        break;
                    }
                    case 1: {
                        ret = this.pdfCreation(fileList[i].getPath());
                        break;
                    }
                    case 2: {
                        ret = this.pdfSigning(fileList[i].getPath());
                    }
                }
                if (ret < -100) break;
                this.pgrBar.setValue(i + 1);
            }
            this.enableUIProgBar(true, 0);
        } else if (file.isFile()) {
            switch (this._processingType) {
                case 0: {
                    ret = this.validateXML(this._xmlFile);
                    break;
                }
                case 1: {
                    ret = this.pdfCreation(this._xmlFile);
                    break;
                }
                case 2: {
                    ret = this.pdfSigning(this._xmlFile);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "introduceti corect calea si numele fisierului");
        }
        this.enableUI(true);
    }

    private void signStatus() {
        if (!this.txtFileName.getText().equals("") && !this.txtPin.getText().equals("") && this.cmbCardType.getSelectedIndex() >= 0) {
            this.btnSign.setEnabled(true);
        } else {
            this.btnSign.setEnabled(false);
        }
    }

    private void changeStatusCombo() {
        Sign.CertAlias certAlias = (Sign.CertAlias)this.cmbCertificates.getSelectedItem();
        X509Certificate cert = certAlias._cert;
        this.txtFurnizor.setText(cert.getIssuerDN().getName());
        this.txtFurnizor.setCaretPosition(0);
        this.txtNume.setText(cert.getSubjectDN().getName());
        this.txtNume.setCaretPosition(0);
        this.txtStartDate.setText(this.dateFormat.format(cert.getNotBefore()));
        this.txtEndDate.setText(this.dateFormat.format(cert.getNotAfter()));
        this.txtSerialNumber.setText(cert.getSerialNumber().toString());
        this.txtSerialNumber.setCaretPosition(0);
    }

    private void fillOptions() {
        this.cmbOptions.removeAllItems();
        Options[] options = this._integrator.getOptions();
        if (options == null) {
            this.cmbOptions.setEnabled(false);
        } else {
            this.cmbOptions.setModel(new DefaultComboBoxModel<Options>(options));
            try {
                String opt = Params.getProperty((String)("_" + this._decType));
                for (int i = 0; i < options.length; ++i) {
                    if (!options[i]._name.equals(opt)) continue;
                    this._flag = false;
                    this.cmbOptions.setSelectedIndex(i);
                    this._flag = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cmbOptions.setEnabled(true);
        }
    }

    private void setVisibleValidationButton() {
        if (!this.txtFileName.getText().equals("")) {
            this.btnValidation.setEnabled(true);
            this.btnPDF.setEnabled(true);
        } else {
            this.btnValidation.setEnabled(false);
            this.btnPDF.setEnabled(false);
        }
        this.signStatus();
    }

    private void getConfigDefaults() {
        if (this._configPath.equals("")) {
            return;
        }
        try {
            String card;
            Params.init((String)(this._configPath + "config.properties"));
            String folder = Params.getProperty((String)"defFolder");
            if (folder != null) {
                this.ctlFileChooser.setCurrentDirectory(new File(folder));
            }
            if ((card = Params.getProperty((String)"defSmartCard")) != null) {
                this.cmbCardType.setSelectedItem(card);
            }
            this._urlVersiuni = Params.getProperty((String)"urlVersiuni");
            if (this._urlVersiuni != null && this._urlVersiuni.equals("")) {
                this._urlVersiuni = null;
            }
            this._offLine = Params.getProperty((String)"offLine");
            if (this._offLine != null && !this._offLine.equals("Y")) {
                this._offLine = null;
            }
            this._javaStartPrefix = Params.getProperty((String)"javaStartPrefix");
            this._javaVersion = Params.getProperty((String)"javaVersion");
            this._ignoraDeclaratiiNoi = Params.getProperty((String)"ignoraDeclaratiiNoi");
            if (this._ignoraDeclaratiiNoi == null || this._ignoraDeclaratiiNoi.equals("")) {
                this._ignoraDeclaratiiNoi = "N";
            }
            this._user = Params.getProperty((String)"user");
            this._pwd = Params.getProperty((String)"pwd");
            this._domain = Params.getProperty((String)"domain");
            this._authentication = Params.getProperty((String)"authentication");
            this._proxy = Params.getProperty((String)"proxy");
            this._proxyIP = Params.getProperty((String)"proxyIP");
            this._proxyPort = Params.getProperty((String)"proxyPort");
            this._defDecl = Params.getProperty((String)"tipDeclaratie");
        }
        finally {
            return;
        }
    }

    private void setConfigDefaults() {
        try {
            Params.setProperty((String)"defFolder", (String)this.ctlFileChooser.getCurrentDirectory().getCanonicalPath());
            if (this.cmbCardType.getSelectedIndex() >= 0) {
                Params.setProperty((String)"defSmartCard", (String)this.cmbCardType.getSelectedItem().toString());
            }
            Params.setProperty((String)"tipDeclaratie", (String)this._decType);
            String dec = null;
            String prefix = null;
            StringBuilder unIns = new StringBuilder();
            for (int i = 0; i < this.lstUnInstalled.getModel().getSize(); ++i) {
                dec = this.lstUnInstalled.getModel().getElementAt(i).toString();
                prefix = Main._libPath + dec;
                if (i != 0) {
                    unIns.append("|");
                }
                unIns.append(dec);
            }
            Params.setProperty((String)"declaratiiDezinstalate", (String)unIns.toString());
            if (this._user != null) {
                Params.setProperty((String)"user", (String)this._user);
            } else {
                Params.removeProperty((String)"user");
            }
            if (this._pwd != null) {
                Params.setProperty((String)"pwd", (String)this._pwd);
            } else {
                Params.removeProperty((String)"pwd");
            }
            if (this._domain != null) {
                Params.setProperty((String)"domain", (String)this._domain);
            } else {
                Params.removeProperty((String)"domain");
            }
            if (this._authentication != null) {
                Params.setProperty((String)"authentication", (String)this._authentication);
            } else {
                Params.removeProperty((String)"authentication");
            }
            if (this._proxy != null && this._proxy.equals("auto")) {
                Params.setProperty((String)"proxy", (String)"auto");
            } else {
                Params.removeProperty((String)"proxy");
            }
            if (this._proxyIP != null && !this._proxyIP.equals("")) {
                Params.setProperty((String)"proxyIP", (String)this._proxyIP);
            } else {
                Params.removeProperty((String)"proxyIP");
            }
            if (this._proxyPort != null && !this._proxyPort.equals("")) {
                Params.setProperty((String)"proxyPort", (String)this._proxyPort);
            } else {
                Params.removeProperty((String)"proxyPort");
            }
            if (this._ignoraDeclaratiiNoi != null && this._ignoraDeclaratiiNoi.equals("D")) {
                Params.setProperty((String)"ignoraDeclaratiiNoi", (String)this._ignoraDeclaratiiNoi);
            } else {
                Params.removeProperty((String)"ignoraDeclaratiiNoi");
            }
            if (this._urlVersiuni != null) {
                Params.setProperty((String)"urlVersiuni", (String)this._urlVersiuni);
            } else {
                Params.removeProperty((String)"urlVersiuni");
            }
            if (this._offLine != null) {
                Params.setProperty((String)"offLine", (String)this._offLine);
            } else {
                Params.removeProperty((String)"offLine");
            }
            if (this._javaStartPrefix != null && !this._javaStartPrefix.equals("")) {
                Params.setProperty((String)"javaStartPrefix", (String)this._javaStartPrefix);
            } else {
                Params.removeProperty((String)"javaStartPrefix");
            }
            if (this._javaVersion != null && !this._javaVersion.equals("")) {
                Params.setProperty((String)"javaVersion", (String)this._javaVersion);
            } else {
                Params.removeProperty((String)"javaVersion");
            }
            Params.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String adjustString(String par) {
        return par == null ? "" : par;
    }

    public String chooseZipFile(String xmlFile, int zipOption) {
        return this.getZipFile(xmlFile, zipOption);
    }

    public String getZipFile(String xmlFile, int zipOption) {
        String zipFile = null;
        String text = null;
        int rez = 0;
        if (zipOption < 0) {
            return "";
        }
        text = zipOption == 0 ? "(optional)" : "(obligatoriu)";
        zipFile = xmlFile.toLowerCase().endsWith(".xml") ? xmlFile.substring(0, xmlFile.length() - 4) + ".zip" : xmlFile + ".zip";
        File file = new File(zipFile);
        if (file.exists()) {
            // empty if block
        }
        this.ctlFileChooser.setDialogTitle("alegeti un fisier zip pt. atasare la fisierul pdf " + text);
        this.ctlFileChooser.resetChoosableFileFilters();
        this.ctlFileChooser.setFileFilter(new FileNameExtensionFilter("fisiere ZIP", "zip"));
        this.ctlFileChooser.setFileSelectionMode(0);
        this.ctlFileChooser.setAcceptAllFileFilterUsed(false);
        rez = this.ctlFileChooser.showOpenDialog(this);
        if (rez == 0) {
            return this.ctlFileChooser.getSelectedFile().getPath();
        }
        if (zipOption == 0) {
            return "";
        }
        return null;
    }

    private void btnValidationMouseClicked(MouseEvent evt) {
        if (this.btnValidation.isEnabled()) {
            this.processFiles(0);
        }
    }

    private void btnGetFileNameMouseClicked(MouseEvent evt) {
        if (!this.btnGetFileName.isEnabled()) {
            return;
        }
        this.ctlFileChooser.setDialogTitle("Alegeti un fisier XML sau PDF sau un FOLDER (pentru toate fisierele XML si PDF)");
        this.ctlFileChooser.resetChoosableFileFilters();
        this.ctlFileChooser.resetChoosableFileFilters();
        this.ctlFileChooser.setAcceptAllFileFilterUsed(false);
        ExtensionFileFilter filter = null;
        filter = new ExtensionFileFilter(new String[]{".XML"}, "Fisiere XML (*.XML)");
        this.ctlFileChooser.addChoosableFileFilter(filter);
        this.ctlFileChooser.addChoosableFileFilter(new ExtensionFileFilter(new String[]{".PDF"}, "Fisiere PDF (*.PDF)"));
        this.ctlFileChooser.addChoosableFileFilter(new ExtensionFileFilter(new String[]{".XML", ".PDF"}, "Fisiere XML si PDF (*.XML|*.PDF)"));
        this.ctlFileChooser.setFileFilter(filter);
        this.ctlFileChooser.setFileSelectionMode(2);
        this.ctlFileChooser.setSelectedFile(null);
        if (this.ctlFileChooser.showOpenDialog(this) == 0) {
            this._xmlFile = this.ctlFileChooser.getSelectedFile().getPath();
            this._crtFilter = (FileFilter)((Object)this.ctlFileChooser.getFileFilter());
            this.txtFileName.setText(this._xmlFile);
            this.setVisibleValidationButton();
        }
    }

    private void txtFileNameKeyReleased(KeyEvent evt) {
        this.setVisibleValidationButton();
        this._xmlFile = this.txtFileName.getText();
    }

    private void btnPDFMouseClicked(MouseEvent evt) {
        if (this.btnPDF.isEnabled()) {
            this.processFiles(1);
        }
    }

    private void btnSignMouseClicked(MouseEvent evt) {
        if (this.btnSign.isEnabled()) {
            this.processFiles(2);
        }
    }

    private void txtPinKeyReleased(KeyEvent evt) {
        this.signStatus();
        this._integrator.setNoCertificate();
    }

    private void cmbCardTypeActionPerformed(ActionEvent evt) {
        this.signStatus();
        this._integrator.setNoCertificate();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setConfigDefaults();
        this._integrator.releaseToken();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.wndChooseCertificate.setVisible(false);
    }

    private void cmbCertificatesActionPerformed(ActionEvent evt) {
        this.changeStatusCombo();
    }

    private void cmbDecTypeActionPerformed(ActionEvent evt) {
        this._decType = this.cmbDecType.getSelectedItem().toString();
        this._integrator.setDeclType(this._decType);
        this._zipOption = this._integrator.getPdfZipOption();
        this.setTitle(_title.replaceAll("%", this._decType).replaceAll("#", "1.2.13.3.3") + this._integrator.getLastVersion() + " / " + this._integrator.getPdfLastVersion());
        this.fillOptions();
    }

    private void cmbOptionsItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            try {
                Options option = (Options)this.cmbOptions.getSelectedItem();
                String opt = DUKFrame.adjustString(option._comments);
                if (!opt.equals("") && this._flag) {
                    this.cmbOptions.hidePopup();
                    this.cmbDecType.hidePopup();
                    JOptionPane.showMessageDialog(this.rootPane, opt, "Atentie!", 2);
                }
                Params.setProperty((String)("_" + this._decType), (String)option._name);
                this._integrator.useOptions(option._options);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this._stopProcessing = true;
    }

    private void mniExitActionPerformed(ActionEvent evt) {
        WindowEvent windowClosing = new WindowEvent(this, 201);
        this.dispatchEvent(windowClosing);
    }

    private void moveAll(JList dest, JList sou) {
        DefaultListModel lstModelDest = (DefaultListModel)dest.getModel();
        DefaultListModel lstModelSou = (DefaultListModel)sou.getModel();
        for (int i = 0; i < lstModelSou.getSize(); ++i) {
            lstModelDest.addElement(lstModelSou.getElementAt(i));
        }
        lstModelSou.removeAllElements();
        dest.setSelectedIndex(0);
    }

    private void moveOne(JList dest, JList sou) {
        DefaultListModel lstModelDest = (DefaultListModel)dest.getModel();
        DefaultListModel lstModelSou = (DefaultListModel)sou.getModel();
        int i = sou.getSelectedIndex();
        if (i < 0) {
            return;
        }
        lstModelDest.addElement(lstModelSou.getElementAt(i));
        lstModelSou.removeElementAt(i);
        int j = sou.getModel().getSize();
        if (j > 0) {
            if (i >= j) {
                i = j - 1;
            }
            sou.setSelectedIndex(i);
        }
    }

    private void setMoveButtons() {
        this.btnUnInstall.setEnabled(false);
        this.btnUnInstallAll.setEnabled(false);
        this.btnUnInstallNothing.setEnabled(false);
        this.btnUnInstallDec.setEnabled(false);
        this.btnKeepDec.setEnabled(false);
        if (this.lstUnInstalled.getModel().getSize() != 0) {
            this.btnUnInstall.setEnabled(true);
            this.btnUnInstallNothing.setEnabled(true);
            this.btnKeepDec.setEnabled(true);
        }
        if (this.lstKept.getModel().getSize() != 0) {
            this.btnUnInstallAll.setEnabled(true);
            this.btnUnInstallDec.setEnabled(true);
        }
    }

    private void btnUnInstallAllActionPerformed(ActionEvent evt) {
        this.moveAll(this.lstUnInstalled, this.lstKept);
        this.setMoveButtons();
    }

    private void btnUnInstallNothingActionPerformed(ActionEvent evt) {
        this.moveAll(this.lstKept, this.lstUnInstalled);
        this.setMoveButtons();
    }

    private void btnUnInstallDecActionPerformed(ActionEvent evt) {
        this.moveOne(this.lstUnInstalled, this.lstKept);
        this.setMoveButtons();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.lstKept.setModel(this._lstKeepModel);
        this.lstUnInstalled.setModel(this._lstUnInstalledModel);
        this.wndUnInstallDec.setVisible(false);
    }

    private void btnUnInstallActionPerformed(ActionEvent evt) {
        this.wndUnInstallDec.setVisible(false);
    }

    private void mniUnInstallDecActionPerformed(ActionEvent evt) {
        int i;
        DefaultListModel model = (DefaultListModel)this.lstKept.getModel();
        this._lstKeepModel = new DefaultListModel();
        for (i = 0; i < model.getSize(); ++i) {
            this._lstKeepModel.addElement(model.getElementAt(i));
        }
        model = (DefaultListModel)this.lstUnInstalled.getModel();
        this._lstUnInstalledModel = new DefaultListModel();
        for (i = 0; i < model.getSize(); ++i) {
            this._lstUnInstalledModel.addElement(model.getElementAt(i));
        }
        this.setMoveButtons();
        this.wndUnInstallDec.setVisible(true);
    }

    private void btnKeepDecActionPerformed(ActionEvent evt) {
        this.moveOne(this.lstKept, this.lstUnInstalled);
        this.setMoveButtons();
    }

    private void wndUnInstallDecWindowClosing(WindowEvent evt) {
        this.wndUnInstallDec.setVisible(false);
    }

    private void chkUserPwdActionPerformed(ActionEvent evt) {
        boolean flag = this.chkUserPwd.isSelected();
        this.txtUser.setEnabled(flag);
        this.txtPwd.setEnabled(flag);
        this.txtDomain.setEnabled(flag);
        this.chkAuthentication.setEnabled(flag);
    }

    private void mniOptionsActionPerformed(ActionEvent evt) {
        this.txtUser.setText("");
        this.txtPwd.setText("");
        this.txtDomain.setText("");
        this.chkAuthentication.setSelected(false);
        if (this._user == null && this._pwd == null && this._domain == null) {
            this.txtUser.setEnabled(false);
            this.txtPwd.setEnabled(false);
            this.txtDomain.setEnabled(false);
            this.chkAuthentication.setEnabled(false);
            this.chkUserPwd.setSelected(false);
        } else {
            this.txtUser.setEnabled(true);
            this.txtPwd.setEnabled(true);
            this.txtDomain.setEnabled(true);
            this.chkAuthentication.setEnabled(true);
            if (this._user != null) {
                this.txtUser.setText(this._user);
            }
            if (this._pwd != null) {
                this.txtPwd.setText(this._pwd);
            }
            if (this._domain != null) {
                this.txtDomain.setText(this._domain);
            }
            if (this._authentication != null) {
                this.chkAuthentication.setSelected(true);
            }
            this.chkUserPwd.setSelected(true);
        }
        if (this._proxy != null && this._proxy.equals("auto")) {
            this.chkAuto.setSelected(true);
        } else {
            this.chkAuto.setSelected(false);
        }
        this.txtProxyIP.setText("");
        this.txtProxyPort.setText("");
        if (this._proxyIP != null && !this._proxyIP.equals("")) {
            this.txtProxyIP.setText(this._proxyIP);
            if (this._proxyPort != null && !this._proxyPort.equals("")) {
                try {
                    long port = Long.parseLong(this._proxyPort);
                    this.txtProxyPort.setText(Long.toString(port));
                }
                catch (Throwable ex) {
                    this.txtProxyPort.setText("80");
                }
            } else {
                this.txtProxyPort.setText("80");
            }
        }
        if (this._ignoraDeclaratiiNoi == null || !this._ignoraDeclaratiiNoi.equals("D")) {
            this.chkNewDeclarations.setSelected(true);
        } else {
            this.chkNewDeclarations.setSelected(false);
        }
        if (this._javaStartPrefix != null) {
            this.txtJavaStart.setText(this._javaStartPrefix);
        }
        if (this._javaVersion != null) {
            this.txtJavaVersion.setText(this._javaVersion);
        }
        if (this._urlVersiuni == null) {
            this.chkOffLine.setSelected(true);
            this.chkOffLine.setEnabled(false);
            this.changeState(false);
            JOptionPane.showMessageDialog(null, "Lipsa urlVersion. Sunteti in mod off line si nu puteti folosi optiunile java start si versiune java." + _newLine + "Lansati java dintr-un .BAT sau in mod linie comanda, de ex:" + _newLine + "java -version:1.6 -Xmx1024M -jar DUKIntegrator.jar");
        } else {
            boolean sw = this._offLine == null;
            this.chkOffLine.setSelected(!sw);
            this.changeState(sw);
        }
        this.wndOptions.setVisible(true);
    }

    private void wndOptionsWindowClosing(WindowEvent evt) {
        this.wndOptions.setVisible(false);
    }

    private void btnAcceptActionPerformed(ActionEvent evt) {
        this._user = null;
        this._pwd = null;
        this._domain = null;
        this._authentication = null;
        if (this.chkUserPwd.isSelected()) {
            this._user = this.txtUser.getText();
            this._pwd = this.txtPwd.getText();
            this._domain = this.txtDomain.getText();
            if (this.chkAuthentication.isSelected()) {
                this._authentication = "Y";
            }
        }
        this._proxy = this.chkAuto.isSelected() ? "auto" : null;
        this._proxyIP = this.txtProxyIP.getText();
        this._proxyPort = this.txtProxyPort.getText();
        this._ignoraDeclaratiiNoi = !this.chkNewDeclarations.isSelected() ? "D" : "N";
        this._javaStartPrefix = this.txtJavaStart.getText();
        if (this._javaStartPrefix != null && this._javaStartPrefix.equals("")) {
            this._javaStartPrefix = null;
        }
        this._javaVersion = this.txtJavaVersion.getText();
        if (this._javaVersion != null && this._javaVersion.equals("")) {
            this._javaVersion = null;
        }
        this.wndOptions.setVisible(false);
    }

    private void btnKeepOldValuesActionPerformed(ActionEvent evt) {
        this.wndOptions.setVisible(false);
    }

    private void mniHelpActionPerformed(ActionEvent evt) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(new File(this._rootPath + "ajutor.chm"));
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(null, "Nu pot deschide fisierul: " + ex.toString());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Nu pot deschide fisierul ajutor.chm pe aceasta platforma");
        }
    }

    private void mniHistoryActionPerformed(ActionEvent evt) {
        if (this._frmIstorie == null) {
            this._frmIstorie = new Istoric(this._rootPath, this._decList);
        }
        this._frmIstorie.setVisible(true);
        if (this._frmIstorie.stare < 0) {
            this._frmIstorie.dispose();
        }
    }

    private void changeState(boolean flag) {
        boolean flag1 = flag & this.chkUserPwd.isSelected();
        this.txtJavaStart.setEnabled(flag);
        this.txtJavaVersion.setEnabled(flag);
        this.txtProxyIP.setEnabled(flag);
        this.txtProxyPort.setEnabled(flag);
        this.txtPwd.setEnabled(flag1);
        this.txtUser.setEnabled(flag1);
        this.txtDomain.setEnabled(flag1);
        this.chkAuthentication.setEnabled(flag1);
        this.chkAuto.setEnabled(flag);
        this.chkNewDeclarations.setEnabled(flag);
        this.chkUserPwd.setEnabled(flag);
        this.jLabel4.setEnabled(flag);
        this.jLabel5.setEnabled(flag);
        this.jLabel6.setEnabled(flag);
        this.jLabel7.setEnabled(flag);
        this.jLabel8.setEnabled(flag);
        this.jLabel9.setEnabled(flag);
        this.jLabel10.setEnabled(flag);
        this.jLabel11.setEnabled(flag);
        this.jLabel12.setEnabled(flag);
    }

    private void chkOffLineActionPerformed(ActionEvent evt) {
        boolean flag = this.chkOffLine.isSelected();
        this.changeState(!flag);
        if (flag) {
            this._offLine = "Y";
            JOptionPane.showMessageDialog(null, "In mod off line nu puteti folosi optiunile java start si versiune java." + _newLine + "Lansati java dintr-un .BAT sau in mod linie comanda, de ex:" + _newLine + "java -version:1.6 -Xmx1024M -jar DUKIntegrator.jar");
        } else {
            this._offLine = null;
        }
    }

    static class ExtensionFileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private List<String> extensions;
        private String description;

        public ExtensionFileFilter(String[] exts, String desc) {
            if (exts != null) {
                this.extensions = new ArrayList<String>();
                for (String ext : exts) {
                    this.extensions.add(ext.replace(".", "").trim().toLowerCase());
                }
            }
            this.description = desc != null ? desc.trim() : "";
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            if (this.extensions == null) {
                return false;
            }
            for (String ext : this.extensions) {
                if (!f.getName().toLowerCase().endsWith("." + ext)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

