/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.FilteredTextRenderListener;
import com.itextpdf.text.pdf.parser.MarkedContentRenderFilter;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.xml.simpleparser.SimpleXMLParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class TaggedPdfReaderTool {
    PdfReader reader;
    PrintWriter out;

    public void convertToXml(PdfReader reader, OutputStream os) throws IOException {
        this.reader = reader;
        this.out = new PrintWriter(os);
        PdfDictionary catalog = reader.getCatalog();
        PdfDictionary struct = catalog.getAsDict(PdfName.STRUCTTREEROOT);
        this.inspectChild(struct.getDirectObject(PdfName.K));
        this.out.flush();
        this.out.close();
    }

    public void inspectChild(PdfObject k) throws IOException {
        if (k == null) {
            return;
        }
        if (k instanceof PdfArray) {
            this.inspectChildArray((PdfArray)k);
        } else if (k instanceof PdfDictionary) {
            this.inspectChildDictionary((PdfDictionary)k);
        }
    }

    public void inspectChildArray(PdfArray k) throws IOException {
        if (k == null) {
            return;
        }
        for (int i = 0; i < k.size(); ++i) {
            this.inspectChild(k.getDirectObject(i));
        }
    }

    public void inspectChildDictionary(PdfDictionary k) throws IOException {
        if (k == null) {
            return;
        }
        PdfName s = k.getAsName(PdfName.S);
        if (s != null) {
            String tag = s.toString().substring(1);
            this.out.print("<");
            this.out.print(tag);
            this.out.print(">");
            PdfDictionary dict = k.getAsDict(PdfName.PG);
            if (dict != null) {
                this.parseTag(tag, k.getDirectObject(PdfName.K), dict);
            }
            this.inspectChild(k.get(PdfName.K));
            this.out.print("</");
            this.out.print(tag);
            this.out.println(">");
        } else {
            this.inspectChild(k.get(PdfName.K));
        }
    }

    public void parseTag(String tag, PdfObject object, PdfDictionary page) throws IOException {
        PRStream stream = (PRStream)page.getAsStream(PdfName.CONTENTS);
        if (object instanceof PdfNumber) {
            PdfNumber mcid = (PdfNumber)object;
            MarkedContentRenderFilter filter = new MarkedContentRenderFilter(mcid.intValue());
            SimpleTextExtractionStrategy strategy = new SimpleTextExtractionStrategy();
            FilteredTextRenderListener listener = new FilteredTextRenderListener(strategy, filter);
            PdfContentStreamProcessor processor = new PdfContentStreamProcessor(listener);
            processor.processContent(PdfReader.getStreamBytes(stream), page.getAsDict(PdfName.RESOURCES));
            this.out.print(SimpleXMLParser.escapeXML(listener.getResultantText(), true));
        } else if (object instanceof PdfArray) {
            PdfArray arr = (PdfArray)object;
            int n = arr.size();
            for (int i = 0; i < n; ++i) {
                this.parseTag(tag, arr.getPdfObject(i), page);
                if (i >= n - 1) continue;
                this.out.println();
            }
        } else if (object instanceof PdfDictionary) {
            PdfDictionary mcr = (PdfDictionary)object;
            this.parseTag(tag, mcr.getDirectObject(PdfName.MCID), mcr.getAsDict(PdfName.PG));
        }
    }
}

