/*
 * Decompiled with CFR 0.152.
 */
package validator;

import dec.LogTrace;
import dec.Params;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class DECConnection {
    private Connection _connection;
    private CallableStatement cstmtDeclaratie;
    private static Cipher _cipher = null;

    public String connectDB(String param, int agentId) {
        String[] parts = null;
        String user = null;
        String pwd = null;
        String text = null;
        String connection = null;
        text = Params.getProperty((String)param);
        if (text == null || text.equals("")) {
            return "conexiune: " + param + " nedefinita in fisierul de configurare";
        }
        parts = text.split(",");
        if (parts.length != 3) {
            return "Sir conectare la BD (" + param + ") eronat in fisier configurare: '" + text;
        }
        user = parts[0];
        pwd = parts[1];
        connection = parts[2];
        String[] encPwd = DECConnection.getRealPwd(user, pwd);
        if (encPwd[0] == null) {
            return "eroare decriptare parola pt. conectare la BD: " + param;
        }
        try {
            Class.forName("oracle.jdbc.OracleDriver");
            text = parts[2];
            parts = text.split("\\|");
            text = parts[agentId % parts.length];
            this._connection = DriverManager.getConnection("jdbc:oracle:thin:@" + text, user, encPwd[0]);
            this._connection.setAutoCommit(false);
            this.cstmtDeclaratie = this._connection.prepareCall("{? = call dec_serv.get_declaratie(?, ?, ?, ?, ?)}");
        }
        catch (Throwable ex) {
            LogTrace.logError((int)2, (Throwable)ex);
            return "Eroare conectare la BD: " + ex.toString();
        }
        if (pwd.equals(encPwd[0])) {
            connection = user + "," + encPwd[1] + "," + connection;
            Params.setProperty((String)param, (String)connection);
            Params.save();
        }
        return null;
    }

    public String close() {
        try {
            this._connection.close();
        }
        catch (SQLException ex) {
            return ex.toString();
        }
        return null;
    }

    public Object[] getDeclaratie(int agentId) {
        String rez = null;
        String tip_per = null;
        String tip_dec = null;
        int an = 0;
        int luna = 0;
        int err = 0;
        try {
            this.cstmtDeclaratie.registerOutParameter(1, 12);
            this.cstmtDeclaratie.registerOutParameter(2, 4);
            this.cstmtDeclaratie.registerOutParameter(3, 12);
            this.cstmtDeclaratie.registerOutParameter(4, 4);
            this.cstmtDeclaratie.registerOutParameter(5, 4);
            this.cstmtDeclaratie.registerOutParameter(6, 12);
            this.cstmtDeclaratie.setInt(2, agentId);
            this.cstmtDeclaratie.execute();
            rez = this.cstmtDeclaratie.getString(1);
            err = this.cstmtDeclaratie.getInt(2);
            tip_dec = this.cstmtDeclaratie.getString(3);
            an = this.cstmtDeclaratie.getInt(4);
            luna = this.cstmtDeclaratie.getInt(5);
            tip_per = this.cstmtDeclaratie.getString(6);
        }
        catch (SQLException ex) {
            return new Object[]{ex.toString(), new Integer(-3), null, new Integer(0), new Integer(0), null};
        }
        return new Object[]{rez, new Integer(err), tip_dec, new Integer(an), new Integer(luna), tip_per};
    }

    public Connection getConnection() {
        return this._connection;
    }

    private static String[] getRealPwd(String user, String pwd) {
        String[] rez = new String[2];
        if (user == null || user.trim().equals("") || pwd == null || pwd.trim().equals("")) {
            rez[0] = null;
            rez[1] = "user sau parola nuli";
            return rez;
        }
        user = user.toLowerCase();
        StringBuffer bf = new StringBuffer(50);
        do {
            bf.append(user).append("_");
        } while (bf.length() < 16);
        byte[] keyBytes = bf.toString().substring(0, 16).getBytes();
        SecretKeySpec key = null;
        byte[] cipherText = null;
        BigInteger bg = null;
        String text = null;
        try {
            if (_cipher == null) {
                _cipher = Cipher.getInstance("AES");
            }
            key = new SecretKeySpec(keyBytes, "AES");
            _cipher.init(2, key);
        }
        catch (Throwable ex) {
            rez[0] = null;
            rez[1] = "esec pregatire decriptare: " + ex.toString();
            return rez;
        }
        try {
            text = pwd.startsWith("_") ? "-" + pwd.substring(1) : pwd;
            bg = new BigInteger(text, 36);
            text = new String(_cipher.doFinal(bg.toByteArray()));
            if (text.startsWith("___") && text.endsWith(user) && text.length() > user.length() + 3 + 2 + 2) {
                text = text.substring(5);
                rez[0] = text.substring(0, text.length() - user.length() - 2);
                rez[1] = pwd;
                return rez;
            }
        }
        catch (Throwable ex) {
            // empty catch block
        }
        rez[0] = pwd;
        try {
            _cipher.init(1, key);
            text = Long.toString(System.currentTimeMillis());
            text = text.substring(text.length() - 2);
            text = "___" + text + pwd + text + user;
            cipherText = _cipher.doFinal(text.getBytes());
            bg = new BigInteger(cipherText);
            if (bg.signum() < 0) {
                bg = bg.negate();
                text = "_" + bg.toString(36);
            } else {
                text = bg.toString(36);
            }
        }
        catch (Throwable ex) {
            rez[0] = null;
            rez[1] = "esec incriptare parola: " + ex.toString();
            return rez;
        }
        rez[1] = text;
        return rez;
    }
}

