/*
 * Decompiled with CFR 0.152.
 */
package pdf;

import dec.Info;
import dec.LogTrace;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import pdf.PdfCreation;

public class PdfSuperCreator {
    private static Map<String, PdfCreation> _creators = new HashMap<String, PdfCreation>();
    private static PdfCreation _crtCreation = null;
    private static String _libPath = null;
    private static String _error = null;

    public PdfSuperCreator() {
        PdfSuperCreator.findPaths(0);
    }

    public String createPdf(String decName, Info info, String pdfFile, String xmlFile, String attFile) {
        int ret = this.prepareDoc(decName);
        if (ret < 0) {
            return _error;
        }
        return _crtCreation.createPdf(info, pdfFile, xmlFile, attFile);
    }

    public String getLastVersion(String decName) {
        int ret = this.prepareDoc(decName);
        if (ret < 0) {
            return null;
        }
        return _crtCreation.getLastVersion();
    }

    public int getZipOption(String decName) {
        int ret = this.prepareDoc(decName);
        if (ret < 0) {
            return ret;
        }
        return _crtCreation.getZipOption();
    }

    public int getZipOption(String decName, Info info) {
        int ret = this.prepareDoc(decName);
        if (ret < 0) {
            return ret;
        }
        return _crtCreation.getZipOption(info);
    }

    private static void findPaths(int level) {
        int len = 0;
        try {
            String par;
            URL url = PdfSuperCreator.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                par = level == 0 ? url.toURI().getPath() : url.getPath();
            }
            catch (Throwable ex) {
                par = url.getPath();
            }
            len = par.indexOf("DecPdf.jar");
            if (len < 0) {
                File lib = new File("lib");
                if (lib.isDirectory()) {
                    _libPath = PdfSuperCreator.padPath(lib.getCanonicalPath());
                    return;
                }
            } else {
                _libPath = PdfSuperCreator.padPath(par.substring(0, len));
                if (new File(_libPath).isDirectory()) {
                    return;
                }
                if (level == 0) {
                    PdfSuperCreator.findPaths(level + 1);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _libPath = null;
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    private int prepareDoc(String decName) {
        try {
            _crtCreation = _creators.get(decName);
            if (_crtCreation != null) {
                return 1;
            }
            if (_libPath == null) {
                _error = "eroare creare Pdf: cale lib nedeterminata";
                PdfSuperCreator.logError(-9, _error);
                return -9;
            }
            String jarName = _libPath + decName + "Pdf.jar";
            File jar = new File(jarName);
            if (!jar.exists()) {
                _error = "eroare creare Pdf: nu gasesc " + jarName;
                PdfSuperCreator.logError(-8, _error);
                return -8;
            }
            URLClassLoader clsLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()});
            String clsName = decName.toLowerCase() + ".PdfCreator";
            _crtCreation = (PdfCreation)Class.forName(clsName, true, clsLoader).newInstance();
            _creators.put(decName, _crtCreation);
        }
        catch (ClassNotFoundException ex) {
            _error = "eroare creare Pdf: " + ex.toString();
            PdfSuperCreator.logError(-6, ex);
            return -6;
        }
        catch (InstantiationException ex) {
            _error = "eroare creare Pdf: " + ex.toString();
            PdfSuperCreator.logError(-7, ex);
            return -7;
        }
        catch (IllegalAccessException ex) {
            _error = "eroare creare Pdf: " + ex.toString();
            PdfSuperCreator.logError(-7, ex);
            return -7;
        }
        catch (Throwable ex) {
            _error = "eroare creare Pdf: " + ex.toString();
            PdfSuperCreator.logError(-5, ex);
            return -5;
        }
        return 0;
    }

    private static void logError(int code, Object msg) {
        if (msg instanceof String) {
            LogTrace.log((String)("modul PdfSuperCreator; eroare=" + Integer.toString(code) + ": " + msg), (int)2);
        } else {
            Throwable ex = (Throwable)msg;
            StackTraceElement[] stack = ex.getStackTrace();
            LogTrace.log((String)("modul PdfSuperCreator; eroare=" + Integer.toString(code) + ": " + ex.toString()), (int)2);
            for (StackTraceElement el : stack) {
                LogTrace.log((String)el.toString(), (int)3);
            }
        }
    }
}

