/*
 * Decompiled with CFR 0.152.
 */
package dec;

import dec.DECValidatorRoot;
import java.sql.CallableStatement;
import java.sql.Connection;

public abstract class DECDbAccessRoot {
    protected Connection _connection;
    private CallableStatement cstmtErrors;
    private CallableStatement cstmtRollBack;
    private CallableStatement cstmtEnqueueValidare;
    private DECValidatorRoot _validator;
    private boolean _stop;

    public void setValidator(DECValidatorRoot validator) {
        this._validator = validator;
    }

    public String connectDB(Connection connection) {
        try {
            this._connection = connection;
            this.cstmtErrors = this._connection.prepareCall("{? = call dec_serv.insert_error(?, ?)}");
            this.cstmtRollBack = this._connection.prepareCall("{call dec_serv.roll_back}");
            this.cstmtEnqueueValidare = this._connection.prepareCall("{? = call dec_serv.enqueue_validare(?)}");
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return null;
    }

    public String rollBack() {
        try {
            this.cstmtRollBack.execute();
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return null;
    }

    public String establishResults(CallableStatement cstmt, String tag) {
        String str = null;
        int type = 0;
        try {
            str = cstmt.getString(1);
            type = cstmt.getInt(2);
        }
        catch (Throwable ex) {
            type = 4;
            str = ex.toString();
        }
        return this.establishResults(str, type, tag);
    }

    public String establishResults(String err, int type, String tag) {
        int val = 0;
        int type_1 = 0;
        if (type < 0) {
            type = -type;
            type_1 = -(type - 1);
        } else {
            type_1 = type - 1;
        }
        if (type > 1) {
            this._stop = true;
        }
        if (type == 0) {
            return err;
        }
        if (err == null || err.length() <= 1) {
            this._validator.addError(type_1);
        } else if (type == 4) {
            this._validator.addError(3, "", "", this._validator.fillParams("eroare insertie @0@ in BD: '@1@'", tag, err), 3);
        } else {
            String[] str = err.split("\\|", 2);
            if (str.length > 1) {
                val = str[0].startsWith("A") ? 0 : (str[0].startsWith("R") ? 1 : (str[0].startsWith("S") ? 2 : 3));
                this._validator.addError(val, str[0].substring(1), "", str[1], type_1);
            } else {
                this._validator.addError(3, "", "", err, type_1);
            }
        }
        return null;
    }

    public String insertError(String header, String error) {
        try {
            this.cstmtErrors.registerOutParameter(1, 12);
            this.cstmtErrors.setString(2, header);
            this.cstmtErrors.setString(3, error);
            this.cstmtErrors.execute();
            return this.cstmtErrors.getString(1);
        }
        catch (Throwable ex) {
            return ex.toString();
        }
    }

    public String enqueueValidare(int idQueue) {
        try {
            this.cstmtEnqueueValidare.registerOutParameter(1, 12);
            this.cstmtEnqueueValidare.setInt(2, idQueue);
            this.cstmtEnqueueValidare.execute();
            return this.cstmtEnqueueValidare.getString(1);
        }
        catch (Throwable ex) {
            return ex.toString();
        }
    }
}

