/*
 * Decompiled with CFR 0.152.
 */
package dec;

import dec.DECDbAccessRoot;
import dec.DECTag;
import dec.DECTagSet;
import dec.DECValidation;
import dec.Info;
import dec.LogTrace;
import dec.Params;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DECValidatorRoot
extends DefaultHandler
implements DECValidation {
    public long _integerValue;
    public double _realValue;
    public Date _dateValue;
    public String _stringValue;
    public boolean _attributeOK;
    private boolean _attributeExists;
    private static final SimpleDateFormat _dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private static String _nl = System.getProperty("line.separator");
    private Pattern _dblPattern = Pattern.compile("\\.");
    private Pattern _datePattern = Pattern.compile("\\d{1,2}.\\d{1,2}.\\d\\d\\d\\d");
    private Pattern _emailPattern = Pattern.compile("[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
    private String _xmlFile;
    private String _errFile;
    private Attributes _attrib;
    private OutputStreamWriter _errorFile;
    private Vector<String> _deferredErrors = new Vector(5, 2);
    private boolean _deferErrors = false;
    private String _errorsMask = null;
    private String _idError;
    private int _errorStatus;
    private int _flagsNextAttribute;
    private int _indStack;
    private String[] _tagNameStack = new String[10];
    private int[] _countStack = new int[10];
    private int _tagCount;
    private int _tagDepth;
    private String _lastTag;
    private static final int BEFORE_START = Integer.MAX_VALUE;
    protected int _status;
    private static final int[] _monthLen = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private DECTagSet _tagSet = null;
    private DECTag _currentTag = null;
    private long[] _precedenceTab = null;
    private HashSet<String> _attribFullList;
    private boolean _emptyAttribListFlag;
    private int _effectiveAttribCount;
    private String _schemaNamespace = null;
    private DECDbAccessRoot _dbObj = null;
    protected boolean _writeDB;
    private Object _params = null;
    public int _extractValuesFlag = 0;
    public Info _info = null;
    public long _option;

    public int parseDocument(String xmlFile, String errFile, Info info, Object params) {
        return this.parseDocument(xmlFile, errFile, info, params, 0);
    }

    public int parseDocument(String xmlFile, String errFile, Info info, Object params, int extractValuesFlag) {
        int level = 2;
        String errMsg = null;
        this._extractValuesFlag = extractValuesFlag;
        this._params = params;
        this._xmlFile = xmlFile;
        this._errFile = errFile == null || errFile.equals("") ? this._xmlFile + ".err.txt" : errFile;
        this._errorFile = null;
        this._errorStatus = 0;
        this._indStack = -1;
        info._schemaNamespace = null;
        this._info = info;
        if (this._dbObj != null) {
            try {
                this._tagCount = this._xmlFile.lastIndexOf("/");
                this._tagDepth = Math.max(this._tagCount, this._xmlFile.lastIndexOf("\\"));
                this._info._decId = Long.parseLong(this._xmlFile.substring(this._tagDepth + 1, this._xmlFile.length() - 4));
                this._xmlFile = Params.establishPath(this._xmlFile, this._info._decId);
                this._errFile = Params.establishPath(this._errFile, this._info._decId);
            }
            catch (Throwable ex) {
                this._info._decId = -1L;
            }
        }
        this._tagCount = 0;
        this._tagDepth = -1;
        this._status = Integer.MAX_VALUE;
        this._idError = "";
        SAXParserFactory factory = null;
        SAXParser saxParser = null;
        this.initializareDocument();
        try {
            factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            saxParser = factory.newSAXParser();
            saxParser.parse(this._xmlFile, (DefaultHandler)this);
        }
        catch (FileNotFoundException ex) {
            level = 3;
            errMsg = ex.toString();
        }
        catch (IOException ex) {
            errMsg = ex.toString();
        }
        catch (ParserConfigurationException ex) {
            errMsg = ex.toString();
        }
        catch (SAXParseException ex) {
            errMsg = ex.toString();
        }
        catch (SAXException ex) {
            errMsg = ex.toString();
        }
        catch (OutOfMemoryError err) {
            level = 3;
            errMsg = err.toString();
        }
        catch (Throwable err) {
            errMsg = err.toString();
        }
        this.finalizeErrorStatus();
        if (errMsg != null) {
            this.addError(3, "", "", this.fillParams("Eroare fatala de parsare: '@0@'", errMsg), level);
            if (level == 3) {
                LogTrace.log("Eroare fatala: " + errMsg, 2);
            }
        }
        try {
            if (this._errorFile != null) {
                this._errorFile.close();
            }
        }
        catch (Throwable ex) {
            LogTrace.log("Eroare fatala: " + ex.toString(), 2);
            this._errorStatus |= 0xF;
        }
        int val = 0;
        if (this.getErrors() != 0) {
            val = -1;
            if (this.hasFatalErrors() != 0) {
                val = -2;
                if (this.hasTechnicalErrors() != 0) {
                    val = -3;
                }
            }
        }
        if (this._dbObj != null && val != -3) {
            try {
                File xml = new File(this._xmlFile);
                xml.delete();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (this._dbObj != null && this._errorStatus != 0 && new File(errFile).exists()) {
            BufferedReader errorInputFile = null;
            String line = null;
            String header = null;
            String rez = null;
            String[] line0 = null;
            StringBuilder error = new StringBuilder(500);
            boolean flag = false;
            boolean flagLine = false;
            try {
                errorInputFile = new BufferedReader(new FileReader(errFile));
                while (true) {
                    if ((line = errorInputFile.readLine()) == null || !line.startsWith(" ")) {
                        if (flag && (rez = this._dbObj.insertError(header, error.toString())) != null) {
                            LogTrace.log("Eroare fatala: " + rez, 2);
                            this._errorStatus |= 0xF;
                            break;
                        }
                        if (line == null) break;
                        flag = true;
                        flagLine = false;
                        error.setLength(0);
                        line0 = line.split("\\|", 2);
                        if (line0.length < 2) {
                            header = "E???";
                        } else {
                            header = line0[0];
                            line = line0[1];
                        }
                    }
                    if (flagLine) {
                        error.append(_nl);
                    }
                    flagLine = true;
                    error.append(line);
                }
            }
            catch (Throwable ex) {
                LogTrace.log("Eroare fatala: " + ex.toString(), 2);
                this._errorStatus |= 0xF;
                val = -3;
            }
            try {
                errorInputFile.close();
                if (val != -3) {
                    File err = new File(this._errFile);
                    err.delete();
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (this._dbObj != null) {
            this.endDeclaratie(val);
        }
        if (val < 0) {
            return val;
        }
        this.finalizareDocument(info);
        if (this.getWarnings() != 0) {
            return 1;
        }
        return 0;
    }

    public int addError(int errType, String ruleOrAttrib, String message0, String message) {
        return this.addError(errType, ruleOrAttrib, message0, message, 1);
    }

    public int addError(int errType, String ruleOrAttrib, String message0, String message, int level) {
        StringBuilder result = new StringBuilder(500);
        String errStr = level == 0 ? "atentionare" : "eroare";
        int levelInt = level;
        if (level < 0) {
            level = -level;
        }
        this._attributeOK = false;
        if (this._errorFile == null) {
            try {
                this._errorFile = new OutputStreamWriter((OutputStream)new FileOutputStream(this._errFile), "UTF-8");
            }
            catch (IOException ex) {
                LogTrace.log("Eroare fatala: " + ex.toString(), 2);
                this._errorStatus |= 0xF;
                return this._errorStatus;
            }
        }
        if (this._dbObj != null) {
            switch (level) {
                case 0: {
                    result.append("A");
                    break;
                }
                case 3: {
                    result.append("T");
                    break;
                }
                default: {
                    result.append("E");
                }
            }
            switch (errType) {
                case 0: {
                    result.append("C");
                    break;
                }
                case 1: {
                    result.append("R");
                    break;
                }
                case 2: {
                    result.append("S");
                    break;
                }
                case 3: {
                    result.append("G");
                }
            }
            result.append(ruleOrAttrib);
            result.append("|");
        }
        if (level == 0) {
            result.append("A:");
        } else if (level == 1) {
            result.append("E:");
        } else if (level == 2) {
            result.append("F:");
        } else {
            result.append("T:");
        }
        if (level > 0 && levelInt > 0 && this._writeDB) {
            this._dbObj.rollBack();
            this._writeDB = false;
        }
        for (int i = 0; i <= this._indStack; ++i) {
            result.append(" ").append(i == 0 ? "" : "sectiune ").append(this._tagNameStack[i]).append(" (").append(Integer.toString(this._countStack[i])).append(")");
            if (i != 0 || this._idError == null || this._idError.equals("")) continue;
            if (!this._deferErrors) {
                result.append(" [").append(this._idError).append("]");
                continue;
            }
            result.append(" [").append(this._errorsMask).append("]");
        }
        if (this._indStack < 0) {
            result.append(" validari globale");
        }
        if (message0 != null && !message0.equals("")) {
            result.append(_nl).append(" ").append(message0);
        }
        result.append(_nl);
        switch (errType) {
            case 0: {
                result.append(" ").append(errStr).append(" atribut: ").append(ruleOrAttrib).append(": ");
                break;
            }
            case 1: {
                result.append(" ").append(errStr).append(" regula: ").append(ruleOrAttrib).append(!ruleOrAttrib.equals("") ? ": " : "");
                break;
            }
            case 2: {
                result.append(" ").append(errStr).append(" structura: ");
                break;
            }
            case 3: {
                result.append(" ");
            }
        }
        result.append(message).append(_nl);
        try {
            if (!this._deferErrors) {
                this._errorFile.write(result.toString());
            } else {
                this._deferredErrors.add(result.toString());
            }
        }
        catch (IOException ex) {
            LogTrace.log("Eroare fatala: " + ex.toString(), 2);
            this._errorStatus |= 0xF;
            return this._errorStatus;
        }
        this._errorStatus = level == 0 ? (this._errorStatus |= 0x10) : (level == 1 ? (this._errorStatus |= 3) : (level == 2 ? (this._errorStatus |= 7) : (this._errorStatus |= 0xF)));
        return this._errorStatus;
    }

    public int addError(int level) {
        int levelInt = level;
        if (level < 0) {
            level = -level;
        }
        if (level > 0 && levelInt > 0 && this._writeDB) {
            this._dbObj.rollBack();
            this._writeDB = false;
        }
        this._errorStatus = level == 0 ? (this._errorStatus |= 0x10) : (level == 1 ? (this._errorStatus |= 3) : (level == 2 ? (this._errorStatus |= 7) : (this._errorStatus |= 0xF)));
        return this._errorStatus;
    }

    public void initDeferredError(String mask) {
        this._deferErrors = true;
        this._errorsMask = mask;
        this._deferredErrors.clear();
    }

    public void exitDeferredError(Object ... params) {
        this._deferErrors = false;
        this.setIdError(this.fillParams(this._errorsMask, params));
        int cnt = this._deferredErrors.size();
        if (cnt != 0) {
            for (int i = 0; i < cnt; ++i) {
                try {
                    this._errorFile.write(this.fillParams(this._deferredErrors.get(i), params));
                    continue;
                }
                catch (IOException ex) {
                    LogTrace.log("Eroare fatala: " + ex.toString(), 2);
                    this._errorStatus |= 0xF;
                    break;
                }
            }
        }
        this._deferredErrors.clear();
    }

    public String nextAttribute(String attributeName, int maxLen, int type, int mandatoryFlag) {
        this._stringValue = null;
        this._integerValue = 0L;
        this._realValue = 0.0;
        this._dateValue = null;
        this._attributeOK = true;
        this._attributeExists = false;
        if ((this._errorStatus & 1) != 0) {
            this._errorStatus |= 2;
        }
        this._errorStatus &= 0xFFFFFFFE;
        this._flagsNextAttribute = 1;
        if ((mandatoryFlag & 0x80) != 0) {
            this._flagsNextAttribute = 0;
        }
        if (this._emptyAttribListFlag) {
            this._attribFullList.add(attributeName);
        }
        if (this._attrib != null) {
            this._stringValue = this._attrib.getValue(attributeName);
        }
        if (this._stringValue != null) {
            if ((mandatoryFlag & 8) == 0) {
                this._stringValue = this._stringValue.trim();
            }
            this._attributeExists = true;
            ++this._effectiveAttribCount;
        }
        if (this._stringValue != null && !this._stringValue.equals("")) {
            switch (type) {
                case 1: {
                    try {
                        this._integerValue = Long.parseLong(this._stringValue);
                    }
                    catch (NumberFormatException err) {
                        this.addError(0, attributeName, "", this.fillParams("numar intreg eronat: '@0@'", this._stringValue), this._flagsNextAttribute);
                    }
                    break;
                }
                case 2: {
                    try {
                        this._realValue = Double.parseDouble(this._stringValue);
                    }
                    catch (NumberFormatException err) {
                        this.addError(0, attributeName, "", this.fillParams("numar real eronat: '@0@'", this._stringValue), this._flagsNextAttribute);
                    }
                    break;
                }
                case 3: {
                    try {
                        this._dateValue = _dateFormat.parse(this._stringValue);
                        if (this._dateValue.getYear() < 0) {
                            throw new ParseException("", 0);
                        }
                        Matcher dateMatcher = this._datePattern.matcher(this._stringValue);
                        if (!dateMatcher.matches()) {
                            throw new ParseException("", 0);
                        }
                    }
                    catch (ParseException err) {
                        this.addError(0, attributeName, "", this.fillParams("data calendaristica eronata: '@0@'", this._stringValue), this._flagsNextAttribute);
                    }
                    break;
                }
                case 4: {
                    if (this._stringValue.length() <= maxLen) break;
                    this.addError(0, attributeName, "", this.fillParams("sir mai lung de @0@ caractere ('@1@')", Integer.toString(maxLen), this._stringValue), this._flagsNextAttribute);
                    break;
                }
                default: {
                    this.addError(0, attributeName, "", "tip de data eronat; eroare de programare", this._flagsNextAttribute);
                }
            }
            if ((mandatoryFlag & 3) == 2) {
                this.addError(0, attributeName, "", this.fillParams("atributul cu valoarea: '@0@' nu trebuie sa existe aici", this._stringValue), this._flagsNextAttribute);
            }
        } else if (this._stringValue != null && this._stringValue.equals("")) {
            if ((mandatoryFlag & 4) == 0) {
                this.addError(0, attributeName, "", "atribut prezent dar vid nepermis", this._flagsNextAttribute);
            }
        } else if ((mandatoryFlag & 3) == 1) {
            this.addError(0, attributeName, "", "atributul trebuie sa existe", this._flagsNextAttribute);
        }
        return this._stringValue;
    }

    public String nextAttributeInList(Object[] list, String attributeName, int maxLen, int type, int mandatoryFlag) {
        int i = 0;
        String res = this.nextAttribute(attributeName, maxLen, type, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        switch (type) {
            case 1: {
                if (Arrays.binarySearch(list, (Object)this._integerValue) < 0) {
                    i = list.length;
                    break;
                }
                i = 0;
                break;
            }
            case 2: {
                for (i = 0; i < list.length && this._realValue != (Double)list[i]; ++i) {
                }
                break;
            }
            case 3: {
                for (i = 0; i < list.length && !this._dateValue.equals((Date)list[i]); ++i) {
                }
                break;
            }
            case 4: {
                i = Arrays.binarySearch(list, this._stringValue) < 0 ? list.length : 0;
            }
        }
        if (i >= list.length) {
            this.addError(0, attributeName, "", this.fillParams("valoarea '@0@' nu se afla in lista", this._stringValue), this._flagsNextAttribute);
        }
        return res;
    }

    public String nextAttributeInInterval(Object limInf, Object limSup, String attributeName, int maxLen, int type, int mandatoryFlag) {
        boolean ok = false;
        String res = this.nextAttribute(attributeName, maxLen, type, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        switch (type) {
            case 1: {
                if (limSup != null && this._integerValue > (Long)limSup || limInf != null && this._integerValue < (Long)limInf) break;
                ok = true;
                break;
            }
            case 2: {
                if (limSup != null && !(this._realValue <= (Double)limSup) || limInf != null && !(this._realValue >= (Double)limInf)) break;
                ok = true;
                break;
            }
            case 3: {
                if (limSup != null && !this._dateValue.before((Date)limSup) && !this._dateValue.equals((Date)limSup) || limInf != null && !this._dateValue.after((Date)limInf) && !this._dateValue.equals((Date)limInf)) break;
                ok = true;
                break;
            }
            case 4: {
                if (limSup != null && this._stringValue.compareTo((String)limSup) > 0 || limInf != null && this._stringValue.compareTo((String)limInf) < 0) break;
                ok = true;
            }
        }
        if (!ok) {
            this.addError(0, attributeName, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue), this._flagsNextAttribute);
        }
        return res;
    }

    public String nextAttributeDblPattern(Object limInf, Object limSup, int intPositions, int fractPositions, String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 0, 2, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (limSup != null && this._realValue > (Double)limSup || limInf != null && this._realValue < (Double)limInf) {
            this.addError(0, attributeName, "", this.fillParams("valoarea '@0@' nu se incadreaza in intervalul cerut", this._stringValue), this._flagsNextAttribute);
            return res;
        }
        String[] fld = this._dblPattern.split(res, 0);
        boolean err = false;
        if (fld.length > 0 && fld[0].length() > intPositions) {
            err = true;
        }
        if (fld.length > 1 && fld[1].length() > fractPositions) {
            err = true;
        }
        if (err) {
            this.addError(0, attributeName, "", this.fillParams("numarul zecimal ('@0@') nu respecta modelul: @1@.@2@", this._stringValue, Integer.toString(intPositions), Integer.toString(fractPositions)), this._flagsNextAttribute);
        }
        return res;
    }

    public char[] getBinaryValues(String str) {
        int len = str.length();
        char[] chr = new char[len];
        str.getChars(0, len, chr, 0);
        for (int i = 0; i < len; ++i) {
            char val = chr[i];
            if (val < '0' || val > '9') {
                return null;
            }
            chr[i] = (char)(val - 48);
        }
        return chr;
    }

    int checkCNP(String cnp) {
        if (cnp.length() == 0) {
            return 0;
        }
        if (cnp.length() != 13) {
            return -1;
        }
        char[] cnp1 = this.getBinaryValues(cnp);
        if (cnp1 == null) {
            return -1;
        }
        char chr = cnp1[0];
        if (chr == '\u0000' || chr == '\t') {
            return -1;
        }
        int year = chr <= '\u0002' || chr >= '\u0007' ? 1900 : (chr >= '\u0005' ? 2000 : 1800);
        int month = cnp1[3] * 10 + cnp1[4];
        int day = cnp1[5] * 10 + cnp1[6];
        if (month == 0 || month > 12 || day == 0 || day > _monthLen[month - 1] || month == 2 && day == 29 && ((year += cnp1[1] * 10 + cnp1[2]) % 4 != 0 || year % 100 == 0 && year % 400 != 0)) {
            return -1;
        }
        day = (cnp1[0] * 2 + cnp1[1] * 7 + cnp1[2] * 9 + cnp1[3] * '\u0001' + cnp1[4] * 4 + cnp1[5] * 6 + cnp1[6] * 3 + cnp1[7] * 5 + cnp1[8] * 8 + cnp1[9] * 2 + cnp1[10] * 7 + cnp1[11] * 9) % 11;
        if (day == 10) {
            day = 1;
        }
        if (day != cnp1[12]) {
            return -1;
        }
        return 0;
    }

    int checkNIF(String cnp) {
        if (cnp.length() == 0) {
            return 0;
        }
        if (cnp.length() != 13) {
            return -1;
        }
        char[] cnp1 = this.getBinaryValues(cnp);
        if (cnp1 == null) {
            return -1;
        }
        char chr = cnp1[0];
        if (chr == '\t') {
            int val = (cnp1[0] * 2 + cnp1[1] * 7 + cnp1[2] * 9 + cnp1[3] * '\u0001' + cnp1[4] * 4 + cnp1[5] * 6 + cnp1[6] * 3 + cnp1[7] * 5 + cnp1[8] * 8 + cnp1[9] * 2 + cnp1[10] * 7 + cnp1[11] * 9) % 11;
            if (val == 10) {
                val = 1;
            }
            if (val != cnp1[12]) {
                return -1;
            }
        } else {
            return this.checkCNP(cnp);
        }
        return 0;
    }

    int checkCUI(String cui) {
        int i;
        char[] cui2 = new char[10];
        int len = cui.length();
        if (len == 0) {
            return 0;
        }
        if (len > 10 || cui.startsWith("0")) {
            return -1;
        }
        char[] cui1 = this.getBinaryValues(cui);
        if (cui1 == null) {
            return -1;
        }
        for (i = 0; i < 10 - len; ++i) {
            cui2[i] = '\u0000';
        }
        for (i = 0; i < len; ++i) {
            cui2[i + 10 - len] = cui1[i];
        }
        len = (cui2[0] * 7 + cui2[1] * 5 + cui2[2] * 3 + cui2[3] * 2 + cui2[4] * '\u0001' + cui2[5] * 7 + cui2[6] * 5 + cui2[7] * 3 + cui2[8] * 2) * 10 % 11;
        if (len == 10) {
            len = 0;
        }
        if (len != cui2[9]) {
            return -1;
        }
        return 0;
    }

    public int checkIban(String iban) {
        if (iban == null) {
            return 0;
        }
        if ((iban = iban.trim()).length() < 5) {
            return -1;
        }
        iban = iban.substring(4) + iban.substring(0, 4);
        char[] charIban = iban.toCharArray();
        int[] val = new int[charIban.length];
        int k = 0;
        int r = 0;
        for (int i = 0; i < val.length; ++i) {
            val[i] = charIban[i];
            if (val[i] >= 48 && val[i] <= 57) {
                if (i == val.length - 4 || i == val.length - 3) {
                    return -1;
                }
                k = val[i] - 48;
            } else if (val[i] >= 65 && val[i] <= 90) {
                if (i == val.length - 2 || i == val.length - 1) {
                    return -1;
                }
                k = val[i] - 55;
            } else {
                return -1;
            }
            r = k > 9 ? (100 * r + k) % 97 : (10 * r + k) % 97;
        }
        if (r != 1) {
            return -1;
        }
        return 0;
    }

    public String nextAttributeStringAsLong(String attributeName, int maxLen, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, maxLen, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.getBinaryValues(res) == null) {
            this.addError(0, attributeName, "", this.fillParams("valoare nenumerica ('@0@')", this._stringValue), this._flagsNextAttribute);
        } else if (maxLen <= 18) {
            this._integerValue = Long.parseLong(res);
        }
        return res;
    }

    public String nextAttributeEmail(String attributeName, int maxLen, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, maxLen, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        Matcher emailMatcher = this._emailPattern.matcher(res);
        if (!emailMatcher.matches()) {
            this.addError(0, attributeName, "", this.fillParams("Email invalid ('@0@')", this._stringValue), 0);
        }
        return res;
    }

    public String nextAttributeAsCnp(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 13, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.checkCNP(res) != 0) {
            this.addError(0, attributeName, "", this.fillParams("CNP invalid ('@0@')", this._stringValue), this._flagsNextAttribute);
        }
        return res;
    }

    public String nextAttributeAsNif(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 13, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.checkNIF(res) != 0) {
            this.addError(0, attributeName, "", this.fillParams("CNP invalid ('@0@')", this._stringValue), this._flagsNextAttribute);
        }
        return res;
    }

    public String nextAttributeAsCui(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 10, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.checkCUI(res) != 0) {
            this.addError(0, attributeName, "", this.fillParams("CUI invalid ('@0@')", this._stringValue), this._flagsNextAttribute);
        }
        return res;
    }

    public String nextAttributeAsCif(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 13, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (res.length() <= 10) {
            if (this.checkCUI(res) != 0) {
                this.addError(0, attributeName, "", this.fillParams("CUI invalid ('@0@')", this._stringValue), this._flagsNextAttribute);
            }
        } else if (res.length() == 13) {
            if (this.checkNIF(res) != 0) {
                this.addError(0, attributeName, "", this.fillParams("CNP invalid ('@0@')", this._stringValue), this._flagsNextAttribute);
            }
        } else {
            this.addError(0, attributeName, "", this.fillParams("Cod identificare fiscala (CIF) invalid ('@0@')", this._stringValue), this._flagsNextAttribute);
        }
        return res;
    }

    public String nextAttributeIban(String attributeName, int mandatoryFlag) {
        String res = this.nextAttribute(attributeName, 34, 4, mandatoryFlag);
        if (this.hasCurrentAttributeErrors() != 0 || res == null || res.equals("")) {
            return res;
        }
        if (this.checkIban(res) != 0) {
            this.addError(0, attributeName, "", this.fillParams("cod IBAN invalid ('@0@')", this._stringValue), this._flagsNextAttribute);
        }
        return res;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public abstract void initializareDocument();

    public abstract void finalizareDocument(Info var1);

    public abstract int validareStartTag(int var1);

    public abstract int validareEndTag(int var1);

    protected void init(DECTag[] taguri, long[] tabelPrecedenta, String namespace) {
        this._tagSet = new DECTagSet(taguri);
        this._precedenceTab = tabelPrecedenta;
        Arrays.sort(this._precedenceTab);
        this._schemaNamespace = namespace;
    }

    public static long startStart(int crt, int prec) {
        return 2 * prec + (2 * crt << 15);
    }

    public static long startEnd(int crt, int prec) {
        return 2 * prec + 1 + (2 * crt << 15);
    }

    public static long endStart(int crt, int prec) {
        return 2 * prec + (2 * crt + 1 << 15);
    }

    public static long endEnd(int crt, int prec) {
        return 2 * prec + 1 + (2 * crt + 1 << 15);
    }

    public static long startAbsolute(int crt, int prec) {
        return prec + (2 * crt << 15);
    }

    public static long endAbsolute(int crt, int prec) {
        return prec + (2 * crt + 1 << 15);
    }

    public static long start(int crt) {
        return Integer.MAX_VALUE + (2 * crt << 15);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int type;
        int maxCnt = 0;
        int minCnt = 0;
        int val = 0;
        if (this._info._schemaNamespace == null) {
            this._info._schemaNamespace = uri;
        }
        ++this._tagCount;
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        ++this._tagDepth;
        this._indStack = this._tagDepth - 1;
        if (this._indStack >= 0) {
            this._tagNameStack[this._indStack] = localName;
            if (localName.equals(this._lastTag)) {
                int n = this._indStack;
                this._countStack[n] = this._countStack[n] + 1;
            } else {
                this._countStack[this._indStack] = 1;
            }
        }
        this._effectiveAttribCount = 0;
        this._attrib = attributes;
        this._currentTag = this._tagSet.getDECTagByName(localName);
        if (this._currentTag == null) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", localName), 2);
            return;
        }
        this._lastTag = localName;
        int index = this._currentTag._tagId;
        if (Arrays.binarySearch(this._precedenceTab, DECValidatorRoot.startAbsolute(index, this._status)) < 0) {
            type = -1;
        } else {
            maxCnt = Math.abs(this._currentTag._tagMaxCount);
            minCnt = Math.abs(this._currentTag._tagMinCount);
            val = 1;
            if (this._indStack >= 0) {
                val = this._countStack[this._indStack];
            }
            if (this._currentTag._tagMaxCount != -1 && maxCnt < val) {
                type = -4;
            } else {
                type = this.validareStartTag(index);
                if (type > 0) {
                    val = type;
                    type = -4;
                } else if (type < -3) {
                    type = -5;
                }
            }
        }
        if (!uri.equals(this._schemaNamespace)) {
            this.addError(2, null, "va rugam sa verificati daca folositi versiunea corecta de PDF inteligent sau daca XML-ul creat contine namespace-ul conform schemei XSD (pentru perioada de raportare)", this.fillParams("namespace ('@0@') lipsa sau incorect la sectiunea @1@. Valoarea corecta este xmlns='@2@'", uri, localName, this._schemaNamespace), 2);
        }
        if (type < 0 && type > -5) {
            String msg = null;
            switch (type) {
                default: {
                    msg = this.fillParams("sectiunea '@0@' este gresit pozitionata sau lipsesc sectiuni anterioare obligatorii", localName);
                    break;
                }
                case -2: {
                    msg = this.fillParams("sectiunea '@0@' apare pe un nivel incorect", localName);
                    break;
                }
                case -3: {
                    msg = this.fillParams("sectiunea @0@' nu poate aparea de mai multe ori in acest context", localName);
                    break;
                }
                case -4: {
                    msg = this.fillParams("prea multe sau prea putine sectiuni repetitive (maximum/minimum @0@/@1@; permise @2@ efective)", Integer.toString(minCnt), Integer.toString(maxCnt), Integer.toString(val));
                }
            }
            this.addError(2, null, "", msg, 2);
        }
        this._status = 2 * index;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        this._indStack = this._tagDepth - 1;
        --this._tagDepth;
        this._currentTag = this._tagSet.getDECTagByName(localName);
        this._lastTag = localName;
        if (this._currentTag == null) {
            this.addError(2, null, "", this.fillParams("sectiune necunoscuta ('@0@')", localName), 2);
            return;
        }
        int index = this._currentTag._tagId;
        int type = Arrays.binarySearch(this._precedenceTab, DECValidatorRoot.endAbsolute(index, this._status)) < 0 ? -1 : this.validareEndTag(index);
        if (type == -1) {
            this.addError(2, null, "", this.fillParams("lipsa sectiune obligatorie inainte de sfarsitul sectiunii '@0@'", localName), 2);
        }
        this._status = 2 * index + 1;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.hasFatalErrors() != 0 || this._extractValuesFlag == 2) {
            return;
        }
        String str = new String(ch, start, length).trim();
        if (str.length() != 0) {
            this.addError(2, null, "", this.fillParams("continut nepermis ('@0@') in sau dupa sectiunea @1@", str, this._lastTag), 2);
            return;
        }
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
    }

    public void fatalError(SAXParseException e) throws SAXException {
    }

    public int getErrors() {
        return this._errorStatus & 0xF;
    }

    public int getWarnings() {
        return this._errorStatus & 0x10;
    }

    public int hasCurrentAttributeErrors() {
        return this._errorStatus & 1;
    }

    public int hasFatalErrors() {
        return this._errorStatus & 4;
    }

    public int hasTechnicalErrors() {
        return this._errorStatus & 8;
    }

    void setIdError(String value) {
        this._idError = value;
    }

    public String adjustString(String par) {
        return par == null ? "" : par;
    }

    public String fillParams(String msg, Object ... params) {
        String res = msg;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceAll("@" + Integer.toString(i) + "@", (params[i] == null ? "'lipsa'" : (String)params[i]).trim());
        }
        return res;
    }

    public void initializeAtribList(Object attrFullList) {
        if (attrFullList == null) {
            this._emptyAttribListFlag = true;
            this._attribFullList = new HashSet();
        } else {
            this._emptyAttribListFlag = false;
            this._attribFullList = (HashSet)attrFullList;
        }
    }

    public Object finalizeAttribCheck() {
        if (this._attrib.getLength() > this._effectiveAttribCount) {
            int len = this._attrib.getLength();
            for (int cnt = 0; cnt < len; ++cnt) {
                boolean isXsi;
                String attrib = this._attrib.getLocalName(cnt);
                if (this._attribFullList.contains(attrib) || (isXsi = this._attrib.getURI(cnt).equals("http://www.w3.org/2001/XMLSchema-instance")) && (!isXsi || attrib.equals("nil") || attrib.equals("type") || attrib.equals("schemaLocation") || attrib.equals("noNamespaceSchemaLocation"))) continue;
                this.addError(0, attrib, "va rugam sa verificati daca folositi versiunea corecta de PDF inteligent sau daca XML-ul creat contine namespace-ul conform schemei XSD (pentru perioada de raportare)", this.fillParams("atribut necunoscut ('@0@') in namespace='@1@'", attrib, isXsi ? "http://www.w3.org/2001/XMLSchema-instance" : this._schemaNamespace));
            }
        }
        if (this._emptyAttribListFlag) {
            return this._attribFullList;
        }
        return null;
    }

    protected abstract DECDbAccessRoot getDbAccess();

    protected abstract void endDeclaratie(int var1);

    public int setDbConnection(Connection con) {
        if (this._dbObj != null) {
            return 1;
        }
        if (con == null) {
            return -1;
        }
        this._dbObj = this.getDbAccess();
        if (this._dbObj.connectDB(con) != null) {
            return -2;
        }
        this._dbObj.setValidator(this);
        return 0;
    }

    public void enableDbOperation() {
        if (this._dbObj != null) {
            this._writeDB = true;
        }
    }

    public void disableDbOperation() {
        this._writeDB = false;
    }

    public void setOption(long option) {
        this._option = option;
    }

    public long round(double val) {
        long ret = Math.round(val);
        if (ret == 0L && val != 0.0) {
            return 1L;
        }
        return ret;
    }

    public Object getParams() {
        return this._params;
    }

    public String getSchemaNamespace() {
        return this._schemaNamespace;
    }

    public void finalizeErrorStatus() {
        if (this.getErrors() != 0 && this._writeDB) {
            this._dbObj.rollBack();
            this._writeDB = false;
        }
    }

    static {
        _dateFormat.setLenient(false);
    }
}

