/*
 * Decompiled with CFR 0.152.
 */
package pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import dec.LogTrace;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import ui.CertificateChooser;

public class Sign {
    private boolean _hasCertificare = false;
    private boolean _expired = false;
    private String _algorithm = null;
    private static String newLine = System.getProperty("line.separator");
    private String _pkcs11config = "";
    private String _library = null;
    private boolean _isSlot = false;
    private Certificate[] _chain;
    private PrivateKey _privateKey;
    Provider _etpkcs11 = null;
    CertAlias _certAlias = null;

    public void setNoCertificate() {
        this._hasCertificare = false;
    }

    public String signPdf(String pdfFile, String pdfFileSigned, String inputPin, String cfgFile, CertificateChooser chooser) {
        String rez = this.signPdfIntern(pdfFile, pdfFileSigned, inputPin, cfgFile, chooser, null);
        if (rez == null || rez.equals("")) {
            return null;
        }
        if (this._algorithm.equals("mscapi") || System.getProperty("os.name").toLowerCase().indexOf("win") < 0) {
            return rez;
        }
        rez = this.signPdfIntern(pdfFile, pdfFileSigned, inputPin, cfgFile, chooser, "mscapi");
        return rez;
    }

    private String signPdfIntern(String pdfFile, String pdfFileSigned, String inputPin, String cfgFile, CertificateChooser chooser, String algorithm) {
        String rez = null;
        if (!this._hasCertificare) {
            rez = this.initSignPdf(inputPin, cfgFile, chooser, algorithm);
            if (rez == null) {
                this._hasCertificare = true;
            } else {
                return rez;
            }
        }
        rez = this.doSignPdf(pdfFile, pdfFileSigned);
        return rez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initSignPdf(String inputPin, String cfgFile, CertificateChooser chooser, String algorithm) {
        this._pkcs11config = "";
        this._algorithm = null;
        this._library = null;
        this._expired = false;
        this._isSlot = false;
        BufferedReader cfg = null;
        String line = null;
        try {
            cfg = new BufferedReader(new FileReader(cfgFile));
            while ((line = cfg.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("#") || line.startsWith(";") || (parts = line.split("=", 2)).length != 2) continue;
                if (parts[0].trim().equals("library")) {
                    this._library = parts[1].trim();
                } else if (parts[0].trim().equals("slotListIndex") || parts[0].trim().equals("slot")) {
                    this._isSlot = true;
                }
                if (parts[0].trim().equals("algorithm")) {
                    this._algorithm = parts[1].trim();
                    continue;
                }
                this._pkcs11config = this._pkcs11config + line + newLine;
            }
        }
        catch (Throwable ex) {
            String string = "eroare fisier configurare: " + ex.getMessage();
            return string;
        }
        finally {
            if (cfg != null) {
                try {
                    cfg.close();
                }
                catch (IOException ex) {
                    return "eroare inchidere fisier configurare: " + ex.getMessage();
                }
            }
        }
        if (this._library == null) {
            return "fisierul de configurare nu contine atributul 'library'";
        }
        if (this._algorithm == null) {
            this._algorithm = algorithm != null ? algorithm : "sunpkcs11";
        }
        if (this._algorithm.equals("sunpkcs11")) {
            String err = null;
            for (int i = 0; i < 10; ++i) {
                this._expired = false;
                err = this.initSunpkcs11(inputPin, cfgFile, chooser);
                if (!this._expired) {
                    return err;
                }
                this._isSlot = true;
            }
            return err;
        }
        if (this._algorithm.equals("mscapi")) {
            return this.initMscapi(inputPin, cfgFile, chooser);
        }
        return "algoritm semnare necunoscut. Corectati in fisierul " + cfgFile + " valoarea atributului 'algorithm'";
    }

    private String initSunpkcs11(String inputPin, String cfgFile, CertificateChooser chooser) {
        KeyStore.PasswordProtection pin = null;
        X509Certificate cert = null;
        if (!this._isSlot) {
            long[] slots = null;
            try {
                Class<?> initArgsClass = Class.forName("sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS");
                Object initArgs = initArgsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Field fld = initArgsClass.getDeclaredField("flags");
                fld.setLong(initArgs, Class.forName("sun.security.pkcs11.wrapper.PKCS11Constants").getField("CKF_OS_LOCKING_OK").getLong(null));
                Class<?> p11Class = Class.forName("sun.security.pkcs11.wrapper.PKCS11");
                Method mth = p11Class.getMethod("getInstance", String.class, String.class, initArgsClass, Boolean.TYPE);
                Object p11 = mth.invoke(null, this._library, "C_GetFunctionList", initArgs, false);
                mth = p11Class.getMethod("C_GetSlotList", Boolean.TYPE);
                slots = (long[])mth.invoke(p11, true);
                if (slots != null && slots.length > 0) {
                    this._pkcs11config = this._pkcs11config + "slot=" + slots[0] + newLine;
                }
            }
            catch (Throwable t) {
                return "eroare acces driver: " + this._library + " (Corectati parametrul library din fisierul dist\\config\\SMART_CARD.cfg astfel incat sa indice calea reala pe calculatorul dumneavoastra catre driverul corespunzator SMART_CARD-ului folosit)" + newLine + "       (" + t + ")";
            }
        }
        try {
            byte[] pkcs11configBytes = this._pkcs11config.getBytes();
            ByteArrayInputStream configStream = new ByteArrayInputStream(pkcs11configBytes);
            Constructor<?> ct = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
            this._etpkcs11 = (Provider)ct.newInstance(configStream);
            Security.addProvider(this._etpkcs11);
            pin = new KeyStore.PasswordProtection(inputPin.toCharArray());
            KeyStore.Builder keyStoreBuilder = KeyStore.Builder.newInstance("PKCS11", this._etpkcs11, pin);
            KeyStore keyStore = keyStoreBuilder.getKeyStore();
            String alias = null;
            String error = "certificatul nu a putut fi detectat";
            int cnt = 0;
            int flag = 0;
            Enumeration<String> e = keyStore.aliases();
            ArrayList<CertAlias> coll = new ArrayList<CertAlias>();
            do {
                ++cnt;
                alias = String.valueOf(e.nextElement());
                if (!keyStore.isKeyEntry(alias)) continue;
                cert = (X509Certificate)keyStore.getCertificate(alias);
                try {
                    cert.checkValidity();
                    coll.add(new CertAlias(alias, cert));
                }
                catch (CertificateExpiredException ex) {
                    error = "Certificat expirat: " + ex.toString();
                    this._expired = true;
                    flag |= 1;
                }
                catch (CertificateNotYetValidException ex) {
                    error = "Certificat nu este inca valid: " + ex.toString();
                    flag |= 2;
                }
                catch (Throwable ex) {
                    error = "Certificat eronat: " + ex.toString();
                    Sign.logError(30, ex);
                    flag |= 4;
                }
            } while (e.hasMoreElements());
            if (coll.size() > 1) {
                this._certAlias = chooser.chooseCertificate(coll);
            } else {
                if (coll.size() == 0) {
                    if (cnt > 1 && flag != 1 && flag != 2 && flag != 4) {
                        error = "Certificatele sunt sau expirate sau nu sunt inca valide sau eronate";
                    }
                    return error;
                }
                this._certAlias = (CertAlias)coll.get(0);
            }
            cert = this._certAlias._cert;
            alias = this._certAlias._alias;
            this._expired = false;
            this._privateKey = (PrivateKey)keyStore.getKey(alias, null);
            this._chain = null;
            this._chain = keyStore.getCertificateChain(alias);
            this._chain[0] = cert;
        }
        catch (ProviderException ex) {
            Sign.logError(1, ex);
            if (ex.getMessage().equals("Initialization failed")) {
                return ex.toString() + " (Probabil aveti un alt tip de SmartCard conectat. Deconectati alte tipuri de SmartCarduri (daca exista) si folositi optiunea \"*autoDetect\")";
            }
            if (ex.getMessage().equals("Error parsing configuration")) {
                return ex.toString() + " (Calea catre driverul SmartCardului (care se afla inscrisa in fisierul .cfg corespunzator acestuia) contine unul din urmatoarele caractere: \"~()\". Solutie: Copiati continutul intregului folder in alta locatie si modificati corespunzator calea din fisierul .cfg. (vezi si http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6581254))";
            }
            return ex.toString();
        }
        catch (KeyStoreException ex) {
            Sign.logError(2, ex);
            if (ex.getMessage().equals("KeyStore instantiation failed")) {
                return ex.toString() + " (Probabil nu aveti nici un SmartCard conectat sau PIN-ul nu este corect sau, daca SmartCardul este Schlumberger, introduceti doar primele 8 caractere ale PIN-ului)";
            }
            return ex.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            Sign.logError(3, ex);
            return ex.toString();
        }
        catch (UnrecoverableKeyException ex) {
            Sign.logError(4, ex);
            return ex.toString();
        }
        catch (Throwable ex) {
            Sign.logError(5, ex);
            return ex.toString();
        }
        return null;
    }

    private String initMscapi(String inputPin, String cfgFile, CertificateChooser chooser) {
        X509Certificate cert = null;
        try {
            this._etpkcs11 = (Provider)Class.forName("sun.security.mscapi.SunMSCAPI").newInstance();
            Security.addProvider(this._etpkcs11);
            KeyStore keyStore = KeyStore.getInstance("Windows-MY");
            keyStore.load(null, inputPin.toCharArray());
            Sign.fixAliases(keyStore);
            String alias = null;
            String error = "certificatul nu a putut fi detectat";
            int cnt = 0;
            int flag = 0;
            Enumeration<String> e = keyStore.aliases();
            ArrayList<CertAlias> coll = new ArrayList<CertAlias>();
            do {
                ++cnt;
                alias = String.valueOf(e.nextElement());
                if (!keyStore.isKeyEntry(alias)) continue;
                cert = (X509Certificate)keyStore.getCertificate(alias);
                try {
                    cert.checkValidity();
                    coll.add(new CertAlias(alias, cert));
                }
                catch (CertificateExpiredException ex) {
                    error = "Certificat expirat: " + ex.toString();
                    this._expired = true;
                    flag |= 1;
                }
                catch (CertificateNotYetValidException ex) {
                    error = "Certificat nu este inca valid: " + ex.toString();
                    flag |= 2;
                }
                catch (Throwable ex) {
                    error = "Certificat eronat: " + ex.toString();
                    Sign.logError(30, ex);
                    flag |= 4;
                }
            } while (e.hasMoreElements());
            if (coll.size() > 1) {
                this._certAlias = chooser.chooseCertificate(coll);
            } else {
                if (coll.size() == 0) {
                    if (cnt > 1 && flag != 1 && flag != 2 && flag != 4) {
                        error = "Certificatele sunt sau expirate sau nu sunt inca valide sau eronate";
                    }
                    return error;
                }
                this._certAlias = (CertAlias)coll.get(0);
            }
            cert = this._certAlias._cert;
            alias = this._certAlias._alias;
            this._expired = false;
            this._privateKey = (PrivateKey)keyStore.getKey(alias, inputPin.toCharArray());
            this._chain = null;
            this._chain = keyStore.getCertificateChain(alias);
            this._chain[0] = cert;
        }
        catch (ProviderException ex) {
            Sign.logError(10, ex);
            if (ex.getMessage().equals("Initialization failed")) {
                return ex.toString() + " (Probabil aveti un alt tip de SmartCard conectat. Deconectati alte tipuri de SmartCarduri (daca exista) si folositi optiunea \"*autoDetect\")";
            }
            if (ex.getMessage().equals("Error parsing configuration")) {
                return ex.toString() + " (Calea catre driverul SmartCardului (care se afla inscrisa in fisierul .cfg corespunzator acestuia) contine unul din urmatoarele caractere: \"~()\". Solutie: Copiati continutul intregului folder in alta locatie si modificati corespunzator calea din fisierul .cfg. (vezi si http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6581254))";
            }
            return ex.toString();
        }
        catch (KeyStoreException ex) {
            Sign.logError(11, ex);
            if (ex.getMessage().equals("KeyStore instantiation failed")) {
                return ex.toString() + " (Probabil nu aveti nici un SmartCard conectat sau PIN-ul nu este corect sau, daca SmartCardul este Schlumberger, introduceti doar primele 8 caractere ale PIN-ului)";
            }
            return ex.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            Sign.logError(12, ex);
            return ex.toString();
        }
        catch (UnrecoverableKeyException ex) {
            Sign.logError(13, ex);
            return ex.toString();
        }
        catch (Throwable ex) {
            Sign.logError(14, ex);
            return ex.toString();
        }
        return null;
    }

    private static void fixAliases(KeyStore keyStore) {
        try {
            Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
            field.setAccessible(true);
            KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
            if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreVeritable.getClass().getName())) {
                field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
                field.setAccessible(true);
                Collection entries = (Collection)field.get(keyStoreVeritable);
                for (Object entry : entries) {
                    field = entry.getClass().getDeclaredField("certChain");
                    field.setAccessible(true);
                    X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                    String hashCode = Integer.toString(certificates[0].hashCode());
                    field = entry.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String alias = (String)field.get(entry);
                    if (alias.equals(hashCode)) continue;
                    field.set(entry, alias.concat(" - ").concat(hashCode));
                }
            }
        }
        catch (Exception exception) {
            Sign.logError(20, exception);
            LogTrace.log((String)("eroare in functia fixAliases(): " + exception.toString()), (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doSignPdf(String pdfFile, String pdfFileSigned) {
        try {
            PdfReader reader = new PdfReader(pdfFile);
            FileOutputStream fout = new FileOutputStream(pdfFileSigned);
            PdfStamper stp = PdfStamper.createSignature((PdfReader)reader, (OutputStream)fout, (char)'\u0000');
            PdfSignatureAppearance sap = stp.getSignatureAppearance();
            sap.setCrypto(null, this._chain, null, PdfSignatureAppearance.SELF_SIGNED);
            sap.setReason("Declaratie unica");
            sap.setVisibleSignature(new Rectangle(500.0f, 775.0f, 600.0f, 675.0f), 1, null);
            sap.setExternalDigest(new byte[((RSAPublicKey)this._certAlias._cert.getPublicKey()).getModulus().bitLength() / 8], null, "RSA");
            sap.preClose();
            byte[] content = this.streamToByteArray(sap.getRangeStream());
            Signature signature = Signature.getInstance("SHA1withRSA", this._etpkcs11);
            signature.initSign(this._privateKey);
            signature.update(content);
            byte[] signatureBytes = signature.sign();
            PdfPKCS7 sig = sap.getSigStandard().getSigner();
            sig.setExternalDigest(signatureBytes, null, "RSA");
            PdfDictionary dic = new PdfDictionary();
            dic.put(PdfName.CONTENTS, (PdfObject)new PdfString(sig.getEncodedPKCS1()).setHexWriting(true));
            sap.close(dic);
            return "";
        }
        catch (FileNotFoundException ex) {
            return ex.toString();
        }
        catch (ProviderException ex) {
            if (ex.getMessage().equals("Initialization failed")) {
                return ex.toString() + " (Probabil aveti un alt tip de SmartCard conectat. Deconectati alte tipuri de SmartCarduri (daca exista) si folositi optiunea \"*autoDetect\")";
            }
            if (!ex.getMessage().equals("Error parsing configuration")) return ex.toString();
            return ex.toString() + " (Calea catre driverul SmartCardului (care se afla inscrisa in fisierul .cfg corespunzator acestuia) contine unul din urmatoarele caractere: \"~()\". Solutie: Copiati continutul intregului folder in alta locatie si modificati corespunzator calea din fisierul .cfg. (vezi si http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6581254))";
        }
        catch (NoSuchAlgorithmException ex) {
            return ex.toString();
        }
        catch (IOException ex) {
            return ex.toString();
        }
        catch (DocumentException ex) {
            return ex.toString();
        }
        catch (InvalidKeyException ex) {
            return ex.toString();
        }
        catch (SignatureException ex) {
            return ex.toString();
        }
        catch (Throwable ex) {
            return ex.toString();
        }
    }

    private byte[] streamToByteArray(InputStream is) throws IOException {
        byte[] buff = new byte[512];
        int read = -1;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = is.read(buff)) >= 0) {
            bos.write(buff, 0, read);
        }
        bos.close();
        return bos.toByteArray();
    }

    public void releaseToken() {
        try {
            for (Provider p : Security.getProviders()) {
                if (!p.getName().contains("SunPKCS11")) continue;
                Security.removeProvider(p.getName());
            }
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void logError(int code, Object msg) {
        if (msg instanceof String) {
            LogTrace.log((String)("modul Sign; eroare=" + Integer.toString(code) + ": " + msg), (int)2);
        } else {
            Throwable ex = (Throwable)msg;
            StackTraceElement[] stack = ex.getStackTrace();
            LogTrace.log((String)("modul Sign; eroare=" + Integer.toString(code) + ": " + ex.toString()), (int)2);
            for (StackTraceElement el : stack) {
                LogTrace.log((String)el.toString(), (int)3);
            }
        }
    }

    public class CertAlias {
        public String _alias;
        public X509Certificate _cert;

        public CertAlias(String alias, X509Certificate cert) {
            this._alias = alias;
            this._cert = cert;
        }

        public String toString() {
            return this._alias;
        }
    }
}

